/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.FileUtils;
import com.intuit.karate.http.ServerConfig;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceResolver;
import com.intuit.karate.template.KarateEngineContext;
import java.io.InputStream;
import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.templatemode.TemplateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KaScriptAttrProcessor
extends AbstractAttributeTagProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KaScriptAttrProcessor.class);
    private static final String SRC = "src";
    private final String hostContextPath;
    private final ResourceResolver resourceResolver;

    public KaScriptAttrProcessor(String dialectPrefix, ServerConfig config) {
        super(TemplateMode.HTML, dialectPrefix, null, false, SRC, false, 1000, false);
        this.resourceResolver = config.getResourceResolver();
        this.hostContextPath = config.getHostContextPath();
    }

    @Override
    protected void doProcess(ITemplateContext ctx, IProcessableElementTag tag, AttributeName an, String src, IElementTagStructureHandler sh) {
        String scope = tag.getAttributeValue(this.getDialectPrefix(), "scope");
        if (scope == null) {
            String noCache;
            if (this.hostContextPath != null) {
                src = this.hostContextPath + (String)src;
            }
            if ((noCache = tag.getAttributeValue(this.getDialectPrefix(), "nocache")) != null) {
                try {
                    Resource resource = this.resourceResolver.resolve((String)src);
                    src = (String)src + "?ts=" + resource.getLastModified();
                }
                catch (Exception e) {
                    logger.warn("nocache failed: {}", (Object)e.getMessage());
                }
                sh.removeAttribute(this.getDialectPrefix(), "nocache");
            }
            sh.setAttribute(SRC, (String)src);
            return;
        }
        InputStream is = this.resourceResolver.resolve((String)src).getStream();
        String js = FileUtils.toString(is);
        if ("local".equals(scope)) {
            KarateEngineContext.get().evalLocal(js, false);
        } else {
            KarateEngineContext.get().evalGlobal(js);
        }
        sh.removeElement();
    }
}

