/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.StringUtils;
import com.intuit.karate.template.KarateEngineContext;
import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.model.IModel;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.model.ITemplateEvent;
import karate.org.thymeleaf.model.IText;
import karate.org.thymeleaf.processor.element.AbstractElementModelProcessor;
import karate.org.thymeleaf.processor.element.IElementModelStructureHandler;
import karate.org.thymeleaf.templatemode.TemplateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KaScriptElemProcessor
extends AbstractElementModelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KaScriptElemProcessor.class);
    protected static final String SCOPE = "scope";
    protected static final String LOCAL = "local";
    protected static final String HEAD = "head";
    protected static final String NOCACHE = "nocache";

    public KaScriptElemProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, "script", false, SCOPE, true, 1000);
    }

    @Override
    protected void doProcess(ITemplateContext ctx, IModel model, IElementModelStructureHandler sh) {
        int depth = ctx.getElementStack().size();
        IProcessableElementTag tag = ctx.getElementStack().get(depth - 1);
        String scope = tag.getAttributeValue(this.getDialectPrefix(), SCOPE);
        int n = model.size();
        while (n-- != 0) {
            String text;
            ITemplateEvent event = model.get(n);
            if (!(event instanceof IText) || (text = StringUtils.trimToNull(((IText)event).getText())) == null) continue;
            if (LOCAL.equals(scope)) {
                KarateEngineContext.get().evalLocal(text, false);
                continue;
            }
            KarateEngineContext.get().evalGlobal(text);
        }
        model.reset();
    }
}

