/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsValue;
import com.intuit.karate.template.KarateEngineContext;
import java.util.Map;
import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.standard.processor.StandardConditionalFixedValueTagProcessor;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.ArrayUtils;
import karate.org.thymeleaf.util.EscapedAttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class KarateAttributeTagProcessor
extends AbstractAttributeTagProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KarateAttributeTagProcessor.class);
    private final ModificationType modificationType;

    protected KarateAttributeTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, ModificationType modificationType) {
        super(templateMode, dialectPrefix, null, false, attrName, true, precedence, true);
        this.modificationType = modificationType;
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String av, IElementTagStructureHandler structureHandler) {
        JsValue jv = KarateEngineContext.get().evalLocalAsObject(av);
        if (!jv.isObject()) {
            logger.warn("value did not evaluate to json: {}", (Object)av);
            return;
        }
        Map<String, Object> map = jv.getAsMap();
        map.forEach((k, v) -> {
            if (this.getTemplateMode() == TemplateMode.HTML && this.modificationType == ModificationType.SUBSTITUTION && ArrayUtils.contains(StandardConditionalFixedValueTagProcessor.ATTR_NAMES, k)) {
                if (JsValue.isTruthy(v)) {
                    structureHandler.setAttribute((String)k, (String)k);
                } else {
                    structureHandler.removeAttribute((String)k);
                }
            } else {
                String newAttributeValue = EscapedAttributeUtils.escapeAttribute(this.getTemplateMode(), v == null ? null : v.toString());
                if (newAttributeValue == null || newAttributeValue.length() == 0) {
                    if (this.modificationType == ModificationType.SUBSTITUTION) {
                        structureHandler.removeAttribute((String)k);
                    }
                } else if (this.modificationType == ModificationType.SUBSTITUTION || !tag.hasAttribute((String)k) || tag.getAttributeValue((String)k).length() == 0) {
                    structureHandler.setAttribute((String)k, newAttributeValue);
                } else {
                    String currentValue = tag.getAttributeValue((String)k);
                    if (this.modificationType == ModificationType.APPEND) {
                        structureHandler.setAttribute((String)k, currentValue + newAttributeValue);
                    } else if (this.modificationType == ModificationType.APPEND_WITH_SPACE) {
                        structureHandler.setAttribute((String)k, currentValue + " " + newAttributeValue);
                    } else if (this.modificationType == ModificationType.PREPEND) {
                        structureHandler.setAttribute((String)k, newAttributeValue + currentValue);
                    } else {
                        structureHandler.setAttribute((String)k, newAttributeValue + " " + currentValue);
                    }
                }
            }
        });
    }

    protected static enum ModificationType {
        SUBSTITUTION,
        APPEND,
        PREPEND,
        APPEND_WITH_SPACE,
        PREPEND_WITH_SPACE;

    }

    public static class KarateAttrprependTagProcessor
    extends KarateAttributeTagProcessor {
        public KarateAttrprependTagProcessor(TemplateMode templateMode, String dialectPrefix) {
            super(templateMode, dialectPrefix, "attrprepend", 900, ModificationType.PREPEND);
        }
    }

    public static class KarateAttrappendTagProcessor
    extends KarateAttributeTagProcessor {
        public KarateAttrappendTagProcessor(TemplateMode templateMode, String dialectPrefix) {
            super(templateMode, dialectPrefix, "attrappend", 900, ModificationType.APPEND);
        }
    }

    public static class KarateAttrTagProcessor
    extends KarateAttributeTagProcessor {
        public KarateAttrTagProcessor(TemplateMode templateMode, String dialectPrefix) {
            super(templateMode, dialectPrefix, "attr", 700, ModificationType.SUBSTITUTION);
        }
    }
}

