/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.template.KarateTemplateResource;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.context.IEngineContext;
import karate.org.thymeleaf.context.IdentifierSequences;
import karate.org.thymeleaf.engine.TemplateData;
import karate.org.thymeleaf.expression.IExpressionObjects;
import karate.org.thymeleaf.inline.IInliner;
import karate.org.thymeleaf.model.IModelFactory;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.templateresource.ITemplateResource;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarateEngineContext
implements IEngineContext {
    private static final Logger logger = LoggerFactory.getLogger(KarateEngineContext.class);
    private static final ThreadLocal<KarateEngineContext> THREAD_LOCAL = new ThreadLocal();
    private final IEngineContext wrapped;
    private final JsEngine jsEngine;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private boolean redirect;

    public static KarateEngineContext initThreadLocal(IEngineContext wrapped, JsEngine engine) {
        KarateEngineContext tec = new KarateEngineContext(wrapped, engine);
        THREAD_LOCAL.set(tec);
        return tec;
    }

    private KarateEngineContext(IEngineContext wrapped, JsEngine jsEngine) {
        this.wrapped = wrapped;
        this.jsEngine = jsEngine;
        jsEngine.put("_", this.context);
    }

    public static KarateEngineContext get() {
        return THREAD_LOCAL.get();
    }

    public static void set(KarateEngineContext kec) {
        THREAD_LOCAL.set(kec);
    }

    public JsEngine getJsEngine() {
        return this.jsEngine;
    }

    public String getCallerTemplateName() {
        TemplateData td = this.wrapped.getTemplateData();
        ITemplateResource tr = td.getTemplateResource();
        if (tr instanceof KarateTemplateResource) {
            KarateTemplateResource ktr = (KarateTemplateResource)tr;
            return ktr.getCaller();
        }
        return null;
    }

    public String getTemplateName() {
        String name = this.wrapped.getTemplateData().getTemplate();
        return name.startsWith("/") ? name.substring(1) : name;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public JsValue evalGlobal(String src) {
        this.getVariableNames().forEach(name -> this.jsEngine.put((String)name, this.getVariable((String)name)));
        try {
            return this.jsEngine.eval(src);
        }
        catch (Exception e) {
            throw JsEngine.fromJsEvalException(src, e, null);
        }
    }

    public JsValue evalLocalAsObject(String src) {
        String temp = src.startsWith("${") ? "`" + src + "`" : "({" + src + "})";
        return this.evalLocal(temp, true);
    }

    public JsValue evalLocal(String src, boolean returnValue) {
        try {
            Value value = this.jsEngine.evalWith(this.getVariableNames(), this::getVariable, src, returnValue);
            return new JsValue(value);
        }
        catch (Exception e) {
            throw JsEngine.fromJsEvalException(src, e, null);
        }
    }

    public void setLocal(String name, Object value) {
        this.context.put(name, value);
    }

    @Override
    public void increaseLevel() {
        if (!this.context.isEmpty()) {
            this.setVariables(this.context);
            this.context.clear();
        }
        this.wrapped.increaseLevel();
    }

    @Override
    public void setVariable(String name, Object value) {
        this.wrapped.setVariable(name, value);
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        this.wrapped.setVariables(variables);
    }

    @Override
    public void removeVariable(String name) {
        this.wrapped.removeVariable(name);
    }

    @Override
    public void setTemplateData(TemplateData template) {
        this.wrapped.setTemplateData(template);
    }

    @Override
    public void decreaseLevel() {
        this.wrapped.decreaseLevel();
    }

    @Override
    public boolean containsVariable(String name) {
        return this.wrapped.containsVariable(name);
    }

    @Override
    public Set<String> getVariableNames() {
        return this.wrapped.getVariableNames();
    }

    @Override
    public Object getVariable(String name) {
        return this.wrapped.getVariable(name);
    }

    @Override
    public boolean isVariableLocal(String name) {
        return this.wrapped.isVariableLocal(name);
    }

    @Override
    public void setSelectionTarget(Object selectionTarget) {
        this.wrapped.setSelectionTarget(selectionTarget);
    }

    @Override
    public void setInliner(IInliner inliner) {
        this.wrapped.setInliner(inliner);
    }

    @Override
    public void setElementTag(IProcessableElementTag elementTag) {
        this.wrapped.setElementTag(elementTag);
    }

    @Override
    public List<IProcessableElementTag> getElementStackAbove(int contextLevel) {
        return this.wrapped.getElementStackAbove(contextLevel);
    }

    @Override
    public int level() {
        return this.wrapped.level();
    }

    @Override
    public TemplateData getTemplateData() {
        return this.wrapped.getTemplateData();
    }

    @Override
    public TemplateMode getTemplateMode() {
        return this.wrapped.getTemplateMode();
    }

    @Override
    public List<TemplateData> getTemplateStack() {
        return this.wrapped.getTemplateStack();
    }

    @Override
    public List<IProcessableElementTag> getElementStack() {
        return this.wrapped.getElementStack();
    }

    @Override
    public Map<String, Object> getTemplateResolutionAttributes() {
        return this.wrapped.getTemplateResolutionAttributes();
    }

    @Override
    public IModelFactory getModelFactory() {
        return this.wrapped.getModelFactory();
    }

    @Override
    public boolean hasSelectionTarget() {
        return this.wrapped.hasSelectionTarget();
    }

    @Override
    public Object getSelectionTarget() {
        return this.wrapped.getSelectionTarget();
    }

    @Override
    public IInliner getInliner() {
        return this.wrapped.getInliner();
    }

    @Override
    public String getMessage(Class<?> origin, String key, Object[] messageParameters, boolean useAbsent) {
        return this.wrapped.getMessage(origin, key, messageParameters, useAbsent);
    }

    @Override
    public String buildLink(String base, Map<String, Object> parameters) {
        return this.wrapped.buildLink(base, parameters);
    }

    @Override
    public IdentifierSequences getIdentifierSequences() {
        return this.wrapped.getIdentifierSequences();
    }

    @Override
    public IEngineConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    @Override
    public IExpressionObjects getExpressionObjects() {
        return this.wrapped.getExpressionObjects();
    }

    @Override
    public Locale getLocale() {
        return this.wrapped.getLocale();
    }
}

