/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.template.KarateAttributeTagProcessor;
import com.intuit.karate.template.KarateEachTagProcessor;
import com.intuit.karate.template.KarateExpression;
import com.intuit.karate.template.KarateWithTagProcessor;
import java.util.HashSet;
import java.util.Set;
import karate.org.thymeleaf.context.IExpressionContext;
import karate.org.thymeleaf.processor.IProcessor;
import karate.org.thymeleaf.standard.StandardDialect;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.standard.expression.IStandardExpressionParser;
import karate.org.thymeleaf.standard.expression.IStandardVariableExpression;
import karate.org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.standard.expression.StandardExpressionParser;
import karate.org.thymeleaf.standard.processor.StandardAttrTagProcessor;
import karate.org.thymeleaf.standard.processor.StandardAttrappendTagProcessor;
import karate.org.thymeleaf.standard.processor.StandardAttrprependTagProcessor;
import karate.org.thymeleaf.standard.processor.StandardEachTagProcessor;
import karate.org.thymeleaf.standard.processor.StandardWithTagProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarateStandardDialect
extends StandardDialect
implements IStandardVariableExpressionEvaluator,
IStandardExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(KarateStandardDialect.class);
    private final StandardExpressionParser expressionParser = new StandardExpressionParser();

    @Override
    public IStandardVariableExpressionEvaluator getVariableExpressionEvaluator() {
        return this;
    }

    @Override
    public IStandardExpressionParser getExpressionParser() {
        return this;
    }

    @Override
    public Set<IProcessor> getProcessors(String dialectPrefix) {
        Set<IProcessor> processors = StandardDialect.createStandardProcessorsSet(dialectPrefix);
        HashSet<IProcessor> patched = new HashSet<IProcessor>(processors.size());
        for (IProcessor p : processors) {
            if (p instanceof StandardEachTagProcessor) {
                p = new KarateEachTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardWithTagProcessor) {
                p = new KarateWithTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardAttrTagProcessor) {
                p = new KarateAttributeTagProcessor.KarateAttrTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardAttrappendTagProcessor) {
                p = new KarateAttributeTagProcessor.KarateAttrappendTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardAttrprependTagProcessor) {
                p = new KarateAttributeTagProcessor.KarateAttrprependTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            patched.add(p);
        }
        return patched;
    }

    @Override
    public Object evaluate(IExpressionContext ctx, IStandardVariableExpression ve, StandardExpressionExecutionContext ec) {
        KarateExpression ke = new KarateExpression(ve.getExpression());
        return ke.execute(ctx);
    }

    @Override
    public IStandardExpression parseExpression(IExpressionContext context, String input) {
        if (input.charAt(0) == '~') {
            return this.expressionParser.parseExpression(context, input);
        }
        return new KarateExpression(input);
    }
}

