/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.template.KarateEngineContext;
import com.intuit.karate.template.KarateStandardDialect;
import com.intuit.karate.template.TemplateContext;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Supplier;
import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.TemplateSpec;
import karate.org.thymeleaf.context.IContext;
import karate.org.thymeleaf.context.IEngineContext;
import karate.org.thymeleaf.context.StandardEngineContextFactory;
import karate.org.thymeleaf.dialect.IDialect;
import karate.org.thymeleaf.engine.TemplateManager;
import karate.org.thymeleaf.exceptions.TemplateOutputException;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.templateresolver.ITemplateResolver;
import karate.org.thymeleaf.util.FastStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarateTemplateEngine {
    private static final Logger logger = LoggerFactory.getLogger(KarateTemplateEngine.class);
    private final StandardEngineContextFactory standardFactory = new StandardEngineContextFactory();
    private final TemplateEngine wrapped = new TemplateEngine();

    public KarateTemplateEngine(Supplier<JsEngine> jsEngine, IDialect ... dialects) {
        this.wrapped.setEngineContextFactory((ec, data, attrs, context) -> {
            IEngineContext engineContext = this.standardFactory.createEngineContext(ec, data, attrs, context);
            return KarateEngineContext.initThreadLocal(engineContext, (JsEngine)jsEngine.get());
        });
        this.wrapped.setDialect(new KarateStandardDialect());
        for (IDialect dialect : dialects) {
            this.wrapped.addDialect(dialect);
        }
    }

    public void addTemplateResolver(ITemplateResolver templateResolver) {
        this.wrapped.addTemplateResolver(templateResolver);
    }

    public void setTemplateResolver(ITemplateResolver templateResolver) {
        this.wrapped.setTemplateResolver(templateResolver);
    }

    public String process(String template) {
        return this.process(template, TemplateContext.LOCALE_US);
    }

    public String process(String template, IContext context) {
        TemplateSpec templateSpec = new TemplateSpec(template, TemplateMode.HTML);
        FastStringWriter stringWriter = new FastStringWriter(100);
        this.process(templateSpec, context, stringWriter);
        return ((Object)stringWriter).toString();
    }

    public void process(TemplateSpec templateSpec, IContext context, Writer writer) {
        try {
            TemplateManager templateManager = this.wrapped.getConfiguration().getTemplateManager();
            templateManager.parseAndProcess(templateSpec, context, writer);
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new TemplateOutputException("error flushing output writer", templateSpec.getTemplate(), -1, -1, e);
            }
        }
        catch (Exception e) {
            KarateEngineContext kec = KarateEngineContext.get();
            if (kec != null && !kec.isRedirect()) {
                while (e.getCause() instanceof Exception) {
                    if (!((e = (Exception)e.getCause()) instanceof TemplateProcessingException)) continue;
                    logger.error("{}", (Object)e.getMessage());
                    if (e.getCause() == null) break;
                    String message = e.getCause().getMessage();
                    logger.error("{}", (Object)message);
                    break;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}", (Object)StringUtils.throwableToString(e));
            }
            throw new RuntimeException(e);
        }
    }
}

