/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsValue;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceResolver;
import com.intuit.karate.template.KarateEngineContext;
import com.intuit.karate.template.KarateTemplateResource;
import java.util.Map;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.templateresolver.ITemplateResolver;
import karate.org.thymeleaf.templateresolver.TemplateResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHtmlTemplateResolver
implements ITemplateResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHtmlTemplateResolver.class);
    private final ResourceResolver resourceResolver;

    public ResourceHtmlTemplateResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Integer getOrder() {
        return 1;
    }

    @Override
    public TemplateResolution resolveTemplate(IEngineConfiguration ec, String ownerTemplate, String name, Map<String, Object> templateResolutionAttributes) {
        if (((String)name).startsWith("${")) {
            JsValue jv = KarateEngineContext.get().evalLocal("`" + (String)name + "`", true);
            name = jv.getAsString();
        }
        if (!((String)name).endsWith(".html")) {
            name = (String)name + ".html";
        }
        Resource resource = this.resourceResolver.resolve(ownerTemplate, (String)name);
        KarateTemplateResource templateResource = new KarateTemplateResource(ownerTemplate, resource);
        return new TemplateResolution(templateResource, TemplateMode.HTML, AlwaysValidCacheEntryValidity.INSTANCE);
    }
}

