/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import karate.com.linecorp.armeria.client.AbstractHttpRequestHandler;
import karate.com.linecorp.armeria.client.ClientHttpObjectEncoder;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.HttpRequestSubscriber;
import karate.com.linecorp.armeria.client.HttpResponseDecoder;
import karate.com.linecorp.armeria.client.WebSocketHttp1RequestSubscriber;
import karate.com.linecorp.armeria.client.WebSocketHttp2RequestSubscriber;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.client.DecodedHttpResponse;
import karate.io.netty.channel.Channel;
import karate.org.reactivestreams.Subscriber;
import karate.org.reactivestreams.Subscription;

abstract class AbstractHttpRequestSubscriber
extends AbstractHttpRequestHandler
implements Subscriber<HttpObject> {
    private static final HttpData EMPTY_EOS = HttpData.empty().withEndOfStream();
    private final HttpRequest request;
    private final boolean http1WebSocket;
    @Nullable
    private Subscription subscription;
    private boolean isSubscriptionCompleted;

    static AbstractHttpRequestSubscriber of(Channel channel, ClientHttpObjectEncoder requestEncoder, HttpResponseDecoder responseDecoder, SessionProtocol protocol, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res, long writeTimeoutMillis, boolean webSocket) {
        if (webSocket) {
            if (protocol.isExplicitHttp1()) {
                return new WebSocketHttp1RequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
            }
            assert (protocol.isExplicitHttp2());
            return new WebSocketHttp2RequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
        }
        return new HttpRequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
    }

    AbstractHttpRequestSubscriber(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis, boolean allowTrailers, boolean keepAlive, boolean http1WebSocket) {
        super(ch, encoder, responseDecoder, originalRes, ctx, timeoutMillis, request.isEmpty(), allowTrailers, keepAlive);
        this.request = request;
        this.http1WebSocket = http1WebSocket;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        if (this.state() == AbstractHttpRequestHandler.State.DONE) {
            this.cancel();
            return;
        }
        RequestHeaders headers = this.mergedRequestHeaders(this.mapHeaders(this.request.headers()));
        boolean needs100Continue = AbstractHttpRequestSubscriber.needs100Continue(headers);
        if (needs100Continue && this.http1WebSocket) {
            this.failRequest(new IllegalArgumentException("a WebSocket request is not allowed to have Expect: 100-continue header"));
            return;
        }
        if (!this.tryInitialize()) {
            return;
        }
        this.writeHeaders(headers, AbstractHttpRequestSubscriber.needs100Continue(headers));
        this.channel().flush();
    }

    RequestHeaders mapHeaders(RequestHeaders headers) {
        return headers;
    }

    @Override
    public void onError(Throwable cause) {
        this.isSubscriptionCompleted = true;
        this.failRequest(cause);
    }

    @Override
    public void onComplete() {
        this.isSubscriptionCompleted = true;
        if (this.state() != AbstractHttpRequestHandler.State.DONE) {
            this.writeData(EMPTY_EOS);
            this.channel().flush();
        }
    }

    @Override
    void onWriteSuccess() {
        if (this.state() == AbstractHttpRequestHandler.State.NEEDS_100_CONTINUE) {
            return;
        }
        this.request();
    }

    private void request() {
        if (!this.isSubscriptionCompleted) {
            assert (this.subscription != null);
            this.subscription.request(1L);
        }
    }

    @Override
    void cancel() {
        this.isSubscriptionCompleted = true;
        assert (this.subscription != null);
        this.subscription.cancel();
    }

    @Override
    final void resume() {
        this.request();
    }

    @Override
    void discardRequestBody() {
        this.cancel();
    }
}

