/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.util.Iterator;
import karate.com.linecorp.armeria.client.AbstractHttpRequestHandler;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.HttpResponseDecoder;
import karate.com.linecorp.armeria.client.HttpResponseWrapper;
import karate.com.linecorp.armeria.common.ContentTooLargeException;
import karate.com.linecorp.armeria.common.ContentTooLargeExceptionBuilder;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.client.DecodedHttpResponse;
import karate.com.linecorp.armeria.internal.client.HttpSession;
import karate.com.linecorp.armeria.internal.common.InboundTrafficController;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.util.collection.IntObjectHashMap;
import karate.io.netty.util.collection.IntObjectMap;

abstract class AbstractHttpResponseDecoder
implements HttpResponseDecoder {
    private final IntObjectMap<HttpResponseWrapper> responses = new IntObjectHashMap<HttpResponseWrapper>();
    private final Channel channel;
    private final InboundTrafficController inboundTrafficController;
    @Nullable
    private HttpSession httpSession;
    private int unfinishedResponses;
    private boolean closing;

    AbstractHttpResponseDecoder(Channel channel, InboundTrafficController inboundTrafficController) {
        this.channel = channel;
        this.inboundTrafficController = inboundTrafficController;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public InboundTrafficController inboundTrafficController() {
        return this.inboundTrafficController;
    }

    @Override
    public HttpResponseWrapper addResponse(@Nullable AbstractHttpRequestHandler requestHandler, int id, DecodedHttpResponse res, ClientRequestContext ctx, EventLoop eventLoop) {
        HttpResponseWrapper newRes = new HttpResponseWrapper(requestHandler, res, eventLoop, ctx, ctx.maxResponseLength());
        HttpResponseWrapper oldRes = this.responses.put(id, newRes);
        this.keepAliveHandler().increaseNumRequests();
        assert (oldRes == null) : "addResponse(" + id + ", " + res + ", " + ctx + "): " + oldRes;
        this.onResponseAdded(id, eventLoop, newRes);
        return newRes;
    }

    abstract void onResponseAdded(int var1, EventLoop var2, HttpResponseWrapper var3);

    @Override
    @Nullable
    public HttpResponseWrapper getResponse(int id) {
        return this.responses.get(id);
    }

    @Override
    @Nullable
    public HttpResponseWrapper removeResponse(int id) {
        if (this.closing) {
            return null;
        }
        HttpResponseWrapper removed = this.responses.remove(id);
        if (removed != null) {
            --this.unfinishedResponses;
            assert (this.unfinishedResponses >= 0) : this.unfinishedResponses;
        }
        return removed;
    }

    @Override
    public boolean hasUnfinishedResponses() {
        return this.unfinishedResponses != 0;
    }

    @Override
    public boolean reserveUnfinishedResponse(int maxUnfinishedResponses) {
        if (this.unfinishedResponses >= maxUnfinishedResponses) {
            return false;
        }
        ++this.unfinishedResponses;
        return true;
    }

    @Override
    public void decrementUnfinishedResponses() {
        --this.unfinishedResponses;
    }

    @Override
    public void failUnfinishedResponses(Throwable cause) {
        if (this.closing) {
            return;
        }
        this.closing = true;
        Iterator iterator = this.responses.values().iterator();
        while (iterator.hasNext()) {
            HttpResponseWrapper res = (HttpResponseWrapper)iterator.next();
            iterator.remove();
            --this.unfinishedResponses;
            res.close(cause);
        }
    }

    @Override
    public HttpSession session() {
        if (this.httpSession != null) {
            return this.httpSession;
        }
        this.httpSession = HttpSession.get(this.channel);
        return this.httpSession;
    }

    static ContentTooLargeException contentTooLargeException(HttpResponseWrapper res, long transferred) {
        ContentTooLargeExceptionBuilder builder = ContentTooLargeException.builder().maxContentLength(res.maxContentLength()).transferred(transferred);
        if (res.contentLengthHeaderValue() >= 0L) {
            builder.contentLength(res.contentLengthHeaderValue());
        }
        return builder.build();
    }
}

