/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import karate.com.linecorp.armeria.client.AbstractEventLoopEntry;
import karate.com.linecorp.armeria.client.AbstractEventLoopState;
import karate.com.linecorp.armeria.client.DefaultEventLoopScheduler;
import karate.io.netty.channel.EventLoop;

final class ArrayBasedEventLoopState
extends AbstractEventLoopState {
    private final AbstractEventLoopEntry[] entries;
    private final int maxNumEventLoops;
    private int allActiveRequests;

    ArrayBasedEventLoopState(List<EventLoop> eventLoops, int maxNumEventLoops, DefaultEventLoopScheduler scheduler) {
        super(eventLoops, scheduler);
        this.maxNumEventLoops = maxNumEventLoops;
        this.entries = new AbstractEventLoopEntry[maxNumEventLoops];
        if (eventLoops.size() == maxNumEventLoops) {
            this.init(0);
        } else {
            this.init(this.scheduler().acquisitionStartIndex(maxNumEventLoops));
        }
    }

    private void init(int acquisitionStartIndex) {
        int initialEventLoopOffset = ThreadLocalRandom.current().nextInt(this.maxNumEventLoops);
        int eventLoopSize = this.eventLoops().size();
        for (int i = 0; i < this.maxNumEventLoops; ++i) {
            int nextIndex = (acquisitionStartIndex + (initialEventLoopOffset + i) % this.maxNumEventLoops) % eventLoopSize;
            this.entries[i] = new Entry(this, this.eventLoops().get(nextIndex), i);
        }
    }

    private AbstractEventLoopEntry targetEntry() {
        int minActiveRequest = Integer.MAX_VALUE;
        int targetIndex = 0;
        for (int i = 0; i < this.maxNumEventLoops; ++i) {
            AbstractEventLoopEntry e = this.entries[i];
            int activeRequests = e.activeRequests();
            if (activeRequests == 0) {
                return e;
            }
            if (minActiveRequest <= activeRequests) continue;
            minActiveRequest = activeRequests;
            targetIndex = i;
        }
        return this.entries[targetIndex];
    }

    @Override
    AbstractEventLoopEntry acquire() {
        this.lock();
        try {
            AbstractEventLoopEntry e = this.targetEntry();
            e.incrementActiveRequests();
            ++this.allActiveRequests;
            AbstractEventLoopEntry abstractEventLoopEntry = e;
            return abstractEventLoopEntry;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    void release(AbstractEventLoopEntry e) {
        this.lock();
        try {
            e.decrementActiveRequests();
            if (--this.allActiveRequests == 0) {
                this.setLastActivityTimeNanos();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    AbstractEventLoopEntry[] entries() {
        return this.entries;
    }

    @Override
    int allActiveRequests() {
        return this.allActiveRequests;
    }

    private static final class Entry
    extends AbstractEventLoopEntry {
        private final int id;
        private int activeRequests;

        Entry(AbstractEventLoopState parent, EventLoop eventLoop, int id) {
            super(parent, eventLoop);
            this.id = id;
        }

        @Override
        int activeRequests() {
            return this.activeRequests;
        }

        @Override
        void incrementActiveRequests() {
            ++this.activeRequests;
        }

        @Override
        void decrementActiveRequests() {
            --this.activeRequests;
        }

        @Override
        int id() {
            return this.id;
        }

        @Override
        int index() {
            throw new UnsupportedOperationException();
        }

        @Override
        void setIndex(int index) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "(" + this.id + ", " + this.activeRequests() + ')';
        }
    }
}

