/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import karate.com.linecorp.armeria.client.HttpClientFactory;
import karate.com.linecorp.armeria.client.HttpClientPipelineConfigurator;
import karate.com.linecorp.armeria.common.SerializationFormat;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.SslContextFactory;
import karate.io.netty.bootstrap.Bootstrap;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelInitializer;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.channel.unix.DomainSocketAddress;
import karate.io.netty.handler.ssl.SslContext;
import karate.io.netty.util.concurrent.Future;
import karate.io.netty.util.concurrent.GenericFutureListener;

final class Bootstraps {
    private final EventLoop eventLoop;
    private final SslContext sslCtxHttp1Only;
    private final SslContext sslCtxHttp1Or2;
    @Nullable
    private final SslContextFactory sslContextFactory;
    private final HttpClientFactory clientFactory;
    private final Bootstrap inetBaseBootstrap;
    @Nullable
    private final Bootstrap unixBaseBootstrap;
    private final Bootstrap[][] inetBootstraps;
    private final Bootstrap @Nullable [][] unixBootstraps;

    Bootstraps(HttpClientFactory clientFactory, EventLoop eventLoop, SslContext sslCtxHttp1Or2, SslContext sslCtxHttp1Only, @Nullable SslContextFactory sslContextFactory) {
        this.eventLoop = eventLoop;
        this.sslCtxHttp1Or2 = sslCtxHttp1Or2;
        this.sslCtxHttp1Only = sslCtxHttp1Only;
        this.sslContextFactory = sslContextFactory;
        this.clientFactory = clientFactory;
        this.inetBaseBootstrap = clientFactory.newInetBootstrap();
        this.inetBaseBootstrap.group(eventLoop);
        this.inetBootstraps = this.staticBootstrapMap(this.inetBaseBootstrap);
        this.unixBaseBootstrap = clientFactory.newUnixBootstrap();
        if (this.unixBaseBootstrap != null) {
            this.unixBaseBootstrap.group(eventLoop);
            this.unixBootstraps = this.staticBootstrapMap(this.unixBaseBootstrap);
        } else {
            this.unixBootstraps = null;
        }
    }

    private Bootstrap[][] staticBootstrapMap(Bootstrap baseBootstrap) {
        Set<SessionProtocol> sessionProtocols = SessionProtocol.httpAndHttpsValues();
        Bootstrap[][] maps = (Bootstrap[][])Array.newInstance(Bootstrap.class, SessionProtocol.values().length, 2);
        for (SessionProtocol p : sessionProtocols) {
            SslContext sslCtx = this.determineSslContext(p);
            this.createAndSetBootstrap(baseBootstrap, maps, p, sslCtx, true);
            this.createAndSetBootstrap(baseBootstrap, maps, p, sslCtx, false);
        }
        return maps;
    }

    SslContext determineSslContext(SessionProtocol desiredProtocol) {
        return desiredProtocol.isExplicitHttp1() ? this.sslCtxHttp1Only : this.sslCtxHttp1Or2;
    }

    private Bootstrap select(boolean isDomainSocket, SessionProtocol desiredProtocol, SerializationFormat serializationFormat) {
        Bootstrap[][] bootstraps;
        Bootstrap[][] bootstrapArray = bootstraps = isDomainSocket ? this.unixBootstraps : this.inetBootstraps;
        assert (bootstraps != null);
        return bootstraps[desiredProtocol.ordinal()][Bootstraps.toIndex(serializationFormat)];
    }

    private void createAndSetBootstrap(Bootstrap baseBootstrap, Bootstrap[][] maps, SessionProtocol desiredProtocol, SslContext sslContext, boolean webSocket) {
        maps[desiredProtocol.ordinal()][Bootstraps.toIndex((boolean)webSocket)] = this.newBootstrap(baseBootstrap, desiredProtocol, sslContext, webSocket, false);
    }

    private static int toIndex(boolean webSocket) {
        return webSocket ? 1 : 0;
    }

    private static int toIndex(SerializationFormat serializationFormat) {
        return Bootstraps.toIndex(serializationFormat == SerializationFormat.WS);
    }

    Bootstrap getOrCreate(SocketAddress remoteAddress, SessionProtocol desiredProtocol, SerializationFormat serializationFormat) {
        Bootstrap baseBootstrap;
        if (!SessionProtocol.httpAndHttpsValues().contains((Object)desiredProtocol)) {
            throw new IllegalArgumentException("Unsupported session protocol: " + (Object)((Object)desiredProtocol));
        }
        boolean isDomainSocket = remoteAddress instanceof DomainSocketAddress;
        if (isDomainSocket && this.unixBaseBootstrap == null) {
            throw new IllegalArgumentException("Domain sockets are not supported by " + this.eventLoop.getClass().getName());
        }
        if (this.sslContextFactory == null || !desiredProtocol.isTls()) {
            return this.select(isDomainSocket, desiredProtocol, serializationFormat);
        }
        Bootstrap bootstrap = baseBootstrap = isDomainSocket ? this.unixBaseBootstrap : this.inetBaseBootstrap;
        assert (baseBootstrap != null);
        return this.newBootstrap(baseBootstrap, remoteAddress, desiredProtocol, serializationFormat);
    }

    private Bootstrap newBootstrap(Bootstrap baseBootstrap, SocketAddress remoteAddress, SessionProtocol desiredProtocol, SerializationFormat serializationFormat) {
        boolean webSocket = serializationFormat == SerializationFormat.WS;
        SslContext sslContext = this.newSslContext(remoteAddress, desiredProtocol);
        return this.newBootstrap(baseBootstrap, desiredProtocol, sslContext, webSocket, true);
    }

    private Bootstrap newBootstrap(Bootstrap baseBootstrap, SessionProtocol desiredProtocol, SslContext sslContext, boolean webSocket, boolean closeSslContext) {
        Bootstrap bootstrap = baseBootstrap.clone();
        bootstrap.handler(this.clientChannelInitializer(desiredProtocol, sslContext, webSocket, closeSslContext));
        return bootstrap;
    }

    SslContext getOrCreateSslContext(SocketAddress remoteAddress, SessionProtocol desiredProtocol) {
        if (this.sslContextFactory == null) {
            return this.determineSslContext(desiredProtocol);
        }
        return this.newSslContext(remoteAddress, desiredProtocol);
    }

    private SslContext newSslContext(SocketAddress remoteAddress, SessionProtocol desiredProtocol) {
        SslContextFactory.SslContextMode sslContextMode;
        String hostname;
        if (remoteAddress instanceof InetSocketAddress) {
            hostname = ((InetSocketAddress)remoteAddress).getHostString();
        } else {
            assert (remoteAddress instanceof DomainSocketAddress);
            hostname = "unix:" + ((DomainSocketAddress)remoteAddress).path();
        }
        SslContextFactory.SslContextMode sslContextMode2 = sslContextMode = desiredProtocol.isExplicitHttp1() ? SslContextFactory.SslContextMode.CLIENT_HTTP1_ONLY : SslContextFactory.SslContextMode.CLIENT;
        assert (this.sslContextFactory != null);
        return this.sslContextFactory.getOrCreate(sslContextMode, hostname);
    }

    boolean shouldReleaseSslContext(SslContext sslContext) {
        return sslContext != this.sslCtxHttp1Only && sslContext != this.sslCtxHttp1Or2;
    }

    void releaseSslContext(SslContext sslContext) {
        if (this.sslContextFactory != null) {
            this.sslContextFactory.release(sslContext);
        }
    }

    private ChannelInitializer<Channel> clientChannelInitializer(final SessionProtocol p, final SslContext sslCtx, final boolean webSocket, final boolean closeSslContext) {
        return new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                if (closeSslContext) {
                    ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)unused -> Bootstraps.this.releaseSslContext(sslCtx)));
                }
                ch.pipeline().addLast(new HttpClientPipelineConfigurator(Bootstraps.this.clientFactory, webSocket, p, sslCtx));
            }
        };
    }
}

