/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import karate.com.linecorp.armeria.client.ClientFactoryOption;
import karate.com.linecorp.armeria.client.ClientFactoryOptionValue;
import karate.com.linecorp.armeria.client.ClientTlsConfig;
import karate.com.linecorp.armeria.client.ConnectionPoolListener;
import karate.com.linecorp.armeria.client.DefaultEventLoopScheduler;
import karate.com.linecorp.armeria.client.DnsResolverGroupBuilder;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.EventLoopScheduler;
import karate.com.linecorp.armeria.client.NullTlsProvider;
import karate.com.linecorp.armeria.client.proxy.ProxyConfig;
import karate.com.linecorp.armeria.client.proxy.ProxyConfigSelector;
import karate.com.linecorp.armeria.common.CommonPools;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.Http1HeaderNaming;
import karate.com.linecorp.armeria.common.TlsProvider;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.outlier.OutlierDetection;
import karate.com.linecorp.armeria.common.util.AbstractOptions;
import karate.com.linecorp.armeria.common.util.TlsEngineType;
import karate.com.linecorp.armeria.internal.common.util.ChannelUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.channel.ChannelOption;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.handler.ssl.SslContextBuilder;
import karate.io.netty.resolver.AddressResolverGroup;

public final class ClientFactoryOptions
extends AbstractOptions<ClientFactoryOption<Object>, ClientFactoryOptionValue<Object>> {
    public static final ClientFactoryOption<EventLoopGroup> WORKER_GROUP = ClientFactoryOption.define("WORKER_GROUP", CommonPools.workerGroup());
    public static final ClientFactoryOption<Boolean> SHUTDOWN_WORKER_GROUP_ON_CLOSE = ClientFactoryOption.define("SHUTDOWN_WORKER_GROUP_ON_CLOSE", false);
    public static final ClientFactoryOption<Function<? super EventLoopGroup, ? extends EventLoopScheduler>> EVENT_LOOP_SCHEDULER_FACTORY = ClientFactoryOption.define("EVENT_LOOP_SCHEDULER_FACTORY", eventLoopGroup -> new DefaultEventLoopScheduler((EventLoopGroup)eventLoopGroup, 0, 0, (List<ToIntFunction<Endpoint>>)ImmutableList.of()));
    public static final ClientFactoryOption<Consumer<? super SslContextBuilder>> TLS_CUSTOMIZER = ClientFactoryOption.define("TLS_CUSTOMIZER", b -> {});
    @Deprecated
    public static final ClientFactoryOption<Boolean> TLS_ALLOW_UNSAFE_CIPHERS = ClientFactoryOption.define("tlsAllowUnsafeCiphers", Flags.tlsAllowUnsafeCiphers());
    @UnstableApi
    public static final ClientFactoryOption<TlsEngineType> TLS_ENGINE_TYPE = ClientFactoryOption.define("tlsEngineType", Flags.tlsEngineType());
    @UnstableApi
    public static final ClientFactoryOption<TlsProvider> TLS_PROVIDER = ClientFactoryOption.define("TLS_PROVIDER", NullTlsProvider.INSTANCE);
    @UnstableApi
    public static final ClientFactoryOption<ClientTlsConfig> TLS_CONFIG = ClientFactoryOption.define("TLS_CONFIG", ClientTlsConfig.NOOP);
    public static final ClientFactoryOption<Function<? super EventLoopGroup, ? extends AddressResolverGroup<? extends InetSocketAddress>>> ADDRESS_RESOLVER_GROUP_FACTORY = ClientFactoryOption.define("ADDRESS_RESOLVER_GROUP_FACTORY", eventLoopGroup -> new DnsResolverGroupBuilder().build((EventLoopGroup)eventLoopGroup));
    public static final ClientFactoryOption<Integer> HTTP2_INITIAL_CONNECTION_WINDOW_SIZE = ClientFactoryOption.define("HTTP2_INITIAL_CONNECTION_WINDOW_SIZE", Flags.defaultHttp2InitialConnectionWindowSize());
    public static final ClientFactoryOption<Integer> HTTP2_INITIAL_STREAM_WINDOW_SIZE = ClientFactoryOption.define("HTTP2_INITIAL_STREAM_WINDOW_SIZE", Flags.defaultHttp2InitialStreamWindowSize());
    public static final ClientFactoryOption<Integer> HTTP2_MAX_FRAME_SIZE = ClientFactoryOption.define("HTTP2_MAX_FRAME_SIZE", Flags.defaultHttp2MaxFrameSize());
    public static final ClientFactoryOption<Long> HTTP2_MAX_HEADER_LIST_SIZE = ClientFactoryOption.define("HTTP2_MAX_HEADER_LIST_SIZE", Flags.defaultHttp2MaxHeaderListSize());
    public static final ClientFactoryOption<Integer> HTTP1_MAX_INITIAL_LINE_LENGTH = ClientFactoryOption.define("HTTP1_MAX_INITIAL_LINE_LENGTH", Flags.defaultHttp1MaxInitialLineLength());
    public static final ClientFactoryOption<Integer> HTTP1_MAX_HEADER_SIZE = ClientFactoryOption.define("HTTP1_MAX_HEADER_SIZE", Flags.defaultHttp1MaxHeaderSize());
    public static final ClientFactoryOption<Integer> HTTP1_MAX_CHUNK_SIZE = ClientFactoryOption.define("HTTP1_MAX_CHUNK_SIZE", Flags.defaultHttp1MaxChunkSize());
    public static final ClientFactoryOption<Long> IDLE_TIMEOUT_MILLIS = ClientFactoryOption.define("IDLE_TIMEOUT_MILLIS", Flags.defaultClientIdleTimeoutMillis());
    @UnstableApi
    public static final ClientFactoryOption<Boolean> KEEP_ALIVE_ON_PING = ClientFactoryOption.define("KEEP_ALIVE_ON_PING", Flags.defaultClientKeepAliveOnPing());
    public static final ClientFactoryOption<Long> PING_INTERVAL_MILLIS = ClientFactoryOption.define("PING_INTERVAL_MILLIS", Flags.defaultPingIntervalMillis());
    public static final ClientFactoryOption<Long> MAX_CONNECTION_AGE_MILLIS = ClientFactoryOption.define("MAX_CONNECTION_AGE_MILLIS", ClientFactoryOptions.clampedDefaultMaxClientConnectionAge());
    @UnstableApi
    public static final ClientFactoryOption<OutlierDetection> CONNECTION_OUTLIER_DETECTION = ClientFactoryOption.define("CONNECTION_OUTLIER_DETECTION", OutlierDetection.disabled());
    public static final ClientFactoryOption<Integer> MAX_NUM_REQUESTS_PER_CONNECTION = ClientFactoryOption.define("MAX_NUM_REQUESTS_PER_CONNECTION", Flags.defaultMaxClientNumRequestsPerConnection());
    public static final ClientFactoryOption<Boolean> USE_HTTP2_PREFACE = ClientFactoryOption.define("USE_HTTP2_PREFACE", Flags.defaultUseHttp2Preface());
    @UnstableApi
    public static final ClientFactoryOption<Boolean> PREFER_HTTP1 = ClientFactoryOption.define("PREFER_HTTP1", Flags.defaultPreferHttp1());
    @UnstableApi
    public static final ClientFactoryOption<Boolean> USE_HTTP2_WITHOUT_ALPN = ClientFactoryOption.define("USE_HTTP2_WITHOUT_ALPN", Flags.defaultUseHttp2WithoutAlpn());
    public static final ClientFactoryOption<Boolean> USE_HTTP1_PIPELINING = ClientFactoryOption.define("USE_HTTP1_PIPELINING", Flags.defaultUseHttp1Pipelining());
    public static final ClientFactoryOption<ConnectionPoolListener> CONNECTION_POOL_LISTENER = ClientFactoryOption.define("CONNECTION_POOL_LISTENER", ConnectionPoolListener.noop());
    public static final ClientFactoryOption<Long> HTTP2_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS = ClientFactoryOption.define("HTTP2_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS", Flags.defaultClientHttp2GracefulShutdownTimeoutMillis());
    public static final ClientFactoryOption<MeterRegistry> METER_REGISTRY = ClientFactoryOption.define("METER_REGISTRY", Flags.meterRegistry());
    public static final ClientFactoryOption<ProxyConfigSelector> PROXY_CONFIG_SELECTOR = ClientFactoryOption.define("PROXY_CONFIG_SELECTOR", ProxyConfigSelector.of(ProxyConfig.direct()));
    public static final ClientFactoryOption<Http1HeaderNaming> HTTP1_HEADER_NAMING = ClientFactoryOption.define("HTTP1_HEADER_NAMING", Http1HeaderNaming.ofDefault());
    public static final ClientFactoryOption<Map<ChannelOption<?>, Object>> CHANNEL_OPTIONS = ClientFactoryOption.define("CHANNEL_OPTIONS", ImmutableMap.of(), newOptions -> {
        for (ChannelOption<?> channelOption : ChannelUtil.prohibitedOptions()) {
            Preconditions.checkArgument(!newOptions.containsKey(channelOption), "prohibited channel option: %s", channelOption);
        }
        return newOptions;
    }, (oldValue, newValue) -> {
        Map newOptions = (Map)newValue.value();
        if (newOptions.isEmpty()) {
            return oldValue;
        }
        Map oldOptions = (Map)oldValue.value();
        if (oldOptions.isEmpty()) {
            return newValue;
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize(oldOptions.size() + newOptions.size());
        oldOptions.forEach((? super K key, ? super V value) -> {
            if (!newOptions.containsKey(key)) {
                builder.put(key, value);
            }
        });
        builder.putAll(newOptions);
        return (ClientFactoryOptionValue)((ClientFactoryOption)newValue.option()).newValue(builder.build());
    });
    @UnstableApi
    public static final ClientFactoryOption<Consumer<? super ChannelPipeline>> CHANNEL_PIPELINE_CUSTOMIZER = ClientFactoryOption.define("CHANNEL_PIPELINE_CUSTOMIZER", v -> {});
    private static final ClientFactoryOptions EMPTY = new ClientFactoryOptions(ImmutableList.of());

    private static long clampedDefaultMaxClientConnectionAge() {
        long connectionAgeMillis = Flags.defaultMaxClientConnectionAgeMillis();
        if (connectionAgeMillis > 0L && connectionAgeMillis < 1000L) {
            return 1000L;
        }
        return connectionAgeMillis;
    }

    public static ClientFactoryOptions of() {
        return EMPTY;
    }

    public static ClientFactoryOptions of(ClientFactoryOptionValue<?> ... values) {
        Objects.requireNonNull(values, "values");
        if (values.length == 0) {
            return EMPTY;
        }
        return ClientFactoryOptions.of(Arrays.asList(values));
    }

    public static ClientFactoryOptions of(Iterable<? extends ClientFactoryOptionValue<?>> values) {
        Objects.requireNonNull(values, "values");
        if (values instanceof ClientFactoryOptions) {
            return (ClientFactoryOptions)values;
        }
        return new ClientFactoryOptions(values);
    }

    public static ClientFactoryOptions of(ClientFactoryOptions baseOptions, ClientFactoryOptionValue<?> ... additionalValues) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(additionalValues, "additionalValues");
        if (additionalValues.length == 0) {
            return baseOptions;
        }
        return new ClientFactoryOptions(baseOptions, (Iterable<? extends ClientFactoryOptionValue<?>>)Arrays.asList(additionalValues));
    }

    public static ClientFactoryOptions of(ClientFactoryOptions baseOptions, Iterable<? extends ClientFactoryOptionValue<?>> additionalValues) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(additionalValues, "additionalValues");
        return new ClientFactoryOptions(baseOptions, additionalValues);
    }

    private ClientFactoryOptions(Iterable<? extends ClientFactoryOptionValue<?>> values) {
        super(values);
    }

    private ClientFactoryOptions(ClientFactoryOptions baseOptions, Iterable<? extends ClientFactoryOptionValue<?>> additionalValues) {
        super(baseOptions, additionalValues);
    }

    public EventLoopGroup workerGroup() {
        return (EventLoopGroup)this.get(WORKER_GROUP);
    }

    public boolean shutdownWorkerGroupOnClose() {
        return (Boolean)this.get(SHUTDOWN_WORKER_GROUP_ON_CLOSE);
    }

    public Function<? super EventLoopGroup, ? extends EventLoopScheduler> eventLoopSchedulerFactory() {
        return (Function)this.get(EVENT_LOOP_SCHEDULER_FACTORY);
    }

    public Map<ChannelOption<?>, Object> channelOptions() {
        return (Map)this.get(CHANNEL_OPTIONS);
    }

    public Consumer<? super SslContextBuilder> tlsCustomizer() {
        return (Consumer)this.get(TLS_CUSTOMIZER);
    }

    public Function<? super EventLoopGroup, ? extends AddressResolverGroup<? extends InetSocketAddress>> addressResolverGroupFactory() {
        return (Function)this.get(ADDRESS_RESOLVER_GROUP_FACTORY);
    }

    public int http2InitialConnectionWindowSize() {
        return (Integer)this.get(HTTP2_INITIAL_CONNECTION_WINDOW_SIZE);
    }

    public int http2InitialStreamWindowSize() {
        return (Integer)this.get(HTTP2_INITIAL_STREAM_WINDOW_SIZE);
    }

    public int http2MaxFrameSize() {
        return (Integer)this.get(HTTP2_MAX_FRAME_SIZE);
    }

    public long http2MaxHeaderListSize() {
        return (Long)this.get(HTTP2_MAX_HEADER_LIST_SIZE);
    }

    public int http1MaxInitialLineLength() {
        return (Integer)this.get(HTTP1_MAX_INITIAL_LINE_LENGTH);
    }

    public int http1MaxHeaderSize() {
        return (Integer)this.get(HTTP1_MAX_HEADER_SIZE);
    }

    public int http1MaxChunkSize() {
        return (Integer)this.get(HTTP1_MAX_CHUNK_SIZE);
    }

    public long idleTimeoutMillis() {
        return (Long)this.get(IDLE_TIMEOUT_MILLIS);
    }

    @UnstableApi
    public boolean keepAliveOnPing() {
        return (Boolean)this.get(KEEP_ALIVE_ON_PING);
    }

    public long pingIntervalMillis() {
        return (Long)this.get(PING_INTERVAL_MILLIS);
    }

    public long maxConnectionAgeMillis() {
        return (Long)this.get(MAX_CONNECTION_AGE_MILLIS);
    }

    public int maxNumRequestsPerConnection() {
        return (Integer)this.get(MAX_NUM_REQUESTS_PER_CONNECTION);
    }

    public boolean useHttp2Preface() {
        return (Boolean)this.get(USE_HTTP2_PREFACE);
    }

    @UnstableApi
    public boolean preferHttp1() {
        return (Boolean)this.get(PREFER_HTTP1);
    }

    @UnstableApi
    public boolean useHttp2WithoutAlpn() {
        return (Boolean)this.get(USE_HTTP2_WITHOUT_ALPN);
    }

    public boolean useHttp1Pipelining() {
        return (Boolean)this.get(USE_HTTP1_PIPELINING);
    }

    public ConnectionPoolListener connectionPoolListener() {
        return (ConnectionPoolListener)this.get(CONNECTION_POOL_LISTENER);
    }

    @UnstableApi
    public OutlierDetection connectionOutlierDetection() {
        return (OutlierDetection)this.get(CONNECTION_OUTLIER_DETECTION);
    }

    public long http2GracefulShutdownTimeoutMillis() {
        return (Long)this.get(HTTP2_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS);
    }

    public MeterRegistry meterRegistry() {
        return (MeterRegistry)this.get(METER_REGISTRY);
    }

    public ProxyConfigSelector proxyConfigSelector() {
        return (ProxyConfigSelector)this.get(PROXY_CONFIG_SELECTOR);
    }

    public Http1HeaderNaming http1HeaderNaming() {
        return (Http1HeaderNaming)this.get(HTTP1_HEADER_NAMING);
    }

    public boolean tlsAllowUnsafeCiphers() {
        return (Boolean)this.get(TLS_ALLOW_UNSAFE_CIPHERS);
    }

    @UnstableApi
    public TlsEngineType tlsEngineType() {
        return (TlsEngineType)((Object)this.get(TLS_ENGINE_TYPE));
    }

    @UnstableApi
    public TlsProvider tlsProvider() {
        return (TlsProvider)this.get(TLS_PROVIDER);
    }

    @UnstableApi
    public ClientTlsConfig tlsConfig() {
        return (ClientTlsConfig)this.get(TLS_CONFIG);
    }

    @UnstableApi
    public Consumer<? super ChannelPipeline> channelPipelineCustomizer() {
        return (Consumer)this.get(CHANNEL_PIPELINE_CUSTOMIZER);
    }
}

