/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.util.Objects;
import karate.com.linecorp.armeria.client.ClientHttpObjectEncoder;
import karate.com.linecorp.armeria.client.Http2ClientConnectionHandler;
import karate.com.linecorp.armeria.client.Http2ClientKeepAliveHandler;
import karate.com.linecorp.armeria.client.UnprocessedRequestException;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.stream.ClosedStreamException;
import karate.com.linecorp.armeria.internal.client.ClosedStreamExceptionUtil;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.common.Http2ObjectEncoder;
import karate.com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import karate.io.netty.channel.ChannelFuture;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelPromise;
import karate.io.netty.handler.codec.http2.Http2Connection;
import karate.io.netty.handler.codec.http2.Http2Headers;
import karate.io.netty.handler.codec.http2.Http2LocalFlowController;

final class ClientHttp2ObjectEncoder
extends Http2ObjectEncoder
implements ClientHttpObjectEncoder {
    private final SessionProtocol protocol;

    ClientHttp2ObjectEncoder(ChannelHandlerContext connectionHandlerCtx, Http2ClientConnectionHandler connectionHandler, SessionProtocol protocol) {
        super(connectionHandlerCtx, connectionHandler);
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        assert (this.keepAliveHandler() instanceof Http2ClientKeepAliveHandler || this.keepAliveHandler() instanceof NoopKeepAliveHandler);
    }

    @Override
    public ChannelFuture doWriteHeaders(int id, int streamId, RequestHeaders headers, boolean endStream, ChannelPromise promise) {
        Http2Connection conn = this.encoder().connection();
        if (this.isStreamPresentAndWritable(streamId)) {
            this.keepAliveHandler().onReadOrWrite();
            return this.encoder().writeHeaders(this.ctx(), streamId, this.convertHeaders(headers), 0, endStream, promise);
        }
        Http2Connection.Endpoint<Http2LocalFlowController> local = conn.local();
        if (local.mayHaveCreatedStream(streamId)) {
            ClosedStreamException closedStreamException = new ClosedStreamException("Cannot create a new stream. streamId: " + streamId + ", lastStreamCreated: " + local.lastStreamCreated());
            return this.newFailedFuture(UnprocessedRequestException.of(closedStreamException));
        }
        return this.encoder().writeHeaders(this.ctx(), streamId, this.convertHeaders(headers), 0, endStream, promise);
    }

    private Http2Headers convertHeaders(HttpHeaders inputHeaders) {
        Http2Headers outputHeaders = ArmeriaHttpUtil.toNettyHttp2ClientHeaders(inputHeaders);
        if (!outputHeaders.contains(HttpHeaderNames.SCHEME)) {
            outputHeaders.add(HttpHeaderNames.SCHEME, this.protocol.isTls() ? SessionProtocol.HTTPS.uriText() : SessionProtocol.HTTP.uriText());
        }
        if (!outputHeaders.contains(HttpHeaderNames.AUTHORITY) && !outputHeaders.contains(HttpHeaderNames.HOST)) {
            InetSocketAddress remoteAddress = (InetSocketAddress)this.channel().remoteAddress();
            outputHeaders.add(HttpHeaderNames.AUTHORITY, ArmeriaHttpUtil.authorityHeader(remoteAddress.getHostName(), remoteAddress.getPort(), this.protocol.defaultPort()));
        }
        return outputHeaders;
    }

    @Override
    public ChannelFuture doWriteTrailers(int id, int streamId, HttpHeaders headers) {
        if (this.isStreamPresentAndWritable(streamId)) {
            this.keepAliveHandler().onReadOrWrite();
            return this.encoder().writeHeaders(this.ctx(), streamId, ArmeriaHttpUtil.toNettyHttp2ClientTrailers(headers), 0, true, this.ctx().newPromise());
        }
        return this.newFailedFuture(ClosedStreamExceptionUtil.newClosedStreamException(this.channel()));
    }
}

