/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import karate.com.linecorp.armeria.client.ClientTlsConfig;
import karate.com.linecorp.armeria.common.AbstractTlsConfigBuilder;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;

@UnstableApi
public final class ClientTlsConfigBuilder
extends AbstractTlsConfigBuilder<ClientTlsConfigBuilder> {
    private boolean tlsNoVerifySet;
    private final Set<String> insecureHosts = new HashSet<String>();

    ClientTlsConfigBuilder() {
    }

    public ClientTlsConfigBuilder tlsNoVerify() {
        this.tlsNoVerifySet = true;
        Preconditions.checkState(this.insecureHosts.isEmpty(), "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        return this;
    }

    public ClientTlsConfigBuilder tlsNoVerifyHosts(String ... insecureHosts) {
        Objects.requireNonNull(insecureHosts, "insecureHosts");
        return this.tlsNoVerifyHosts(ImmutableList.copyOf(insecureHosts));
    }

    public ClientTlsConfigBuilder tlsNoVerifyHosts(Iterable<String> insecureHosts) {
        Objects.requireNonNull(insecureHosts, "insecureHosts");
        Preconditions.checkState(!this.tlsNoVerifySet, "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        insecureHosts.forEach(this.insecureHosts::add);
        return this;
    }

    public ClientTlsConfig build() {
        return new ClientTlsConfig(this.allowsUnsafeCiphers(), this.meterIdPrefix(), this.tlsCustomizer(), this.tlsNoVerifySet, ImmutableSet.copyOf(this.insecureHosts));
    }
}

