/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import karate.com.linecorp.armeria.client.ConnectionPoolListenerAdapter;
import karate.com.linecorp.armeria.client.ConnectionPoolLoggingListener;
import karate.com.linecorp.armeria.client.MetricCollectingConnectionPoolListener;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.common.util.SafeCloseable;
import karate.com.linecorp.armeria.common.util.Ticker;
import karate.com.linecorp.armeria.common.util.Unwrappable;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.util.AttributeMap;

public interface ConnectionPoolListener
extends SafeCloseable,
Unwrappable {
    public static ConnectionPoolListener noop() {
        return ConnectionPoolListenerAdapter.NOOP;
    }

    public static ConnectionPoolListener logging() {
        return new ConnectionPoolLoggingListener();
    }

    public static ConnectionPoolListener logging(Ticker ticker) {
        return new ConnectionPoolLoggingListener(ticker);
    }

    @UnstableApi
    public static ConnectionPoolListener metricCollecting(MeterRegistry registry) {
        return ConnectionPoolListener.metricCollecting(registry, new MeterIdPrefix("armeria.client"));
    }

    @UnstableApi
    public static ConnectionPoolListener metricCollecting(MeterRegistry registry, MeterIdPrefix meterIdPrefix) {
        return new MetricCollectingConnectionPoolListener(registry, meterIdPrefix);
    }

    public void connectionOpen(SessionProtocol var1, InetSocketAddress var2, InetSocketAddress var3, AttributeMap var4) throws Exception;

    public void connectionClosed(SessionProtocol var1, InetSocketAddress var2, InetSocketAddress var3, AttributeMap var4) throws Exception;

    @Override
    default public ConnectionPoolListener unwrap() {
        return this;
    }

    @Override
    default public void close() {
    }
}

