/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import karate.com.linecorp.armeria.client.ConnectionPoolListener;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.util.TextFormatter;
import karate.com.linecorp.armeria.common.util.Ticker;
import karate.io.netty.util.AttributeKey;
import karate.io.netty.util.AttributeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectionPoolLoggingListener
implements ConnectionPoolListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPoolLoggingListener.class);
    private static final AttributeKey<Long> OPEN_NANOS = AttributeKey.valueOf(ConnectionPoolLoggingListener.class, "OPEN_NANOS");
    private final AtomicInteger activeChannels = new AtomicInteger();
    private final Ticker ticker;

    ConnectionPoolLoggingListener() {
        this(Ticker.systemTicker());
    }

    ConnectionPoolLoggingListener(Ticker ticker) {
        this.ticker = Objects.requireNonNull(ticker, "ticker");
    }

    @Override
    public void connectionOpen(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr, AttributeMap attrs) throws Exception {
        int activeChannels = this.activeChannels.incrementAndGet();
        if (logger.isInfoEnabled()) {
            attrs.attr(OPEN_NANOS).set(this.ticker.read());
            logger.info("[L:{} - R:{}][{}] OPEN (active channels: {})", new Object[]{localAddr, remoteAddr, protocol.uriText(), activeChannels});
        }
    }

    @Override
    public void connectionClosed(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr, AttributeMap attrs) throws Exception {
        int activeChannels = this.activeChannels.decrementAndGet();
        if (logger.isInfoEnabled() && attrs.hasAttr(OPEN_NANOS)) {
            long closeNanos = this.ticker.read();
            long elapsedNanos = closeNanos - attrs.attr(OPEN_NANOS).get();
            logger.info("[L:{} ! R:{}][{}] CLOSED (lasted for: {}, active channels: {})", new Object[]{localAddr, remoteAddr, protocol.uriText(), TextFormatter.elapsed(elapsedNanos, TimeUnit.NANOSECONDS), activeChannels});
        }
    }
}

