/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.URI;
import karate.com.linecorp.armeria.client.BlockingWebClient;
import karate.com.linecorp.armeria.client.BlockingWebClientRequestPreparation;
import karate.com.linecorp.armeria.client.ClientOptions;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.RequestOptions;
import karate.com.linecorp.armeria.client.ResponseAs;
import karate.com.linecorp.armeria.client.WebClient;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.Scheme;

final class DefaultBlockingWebClient
implements BlockingWebClient {
    static final DefaultBlockingWebClient DEFAULT = new DefaultBlockingWebClient(WebClient.of());
    private final WebClient delegate;

    DefaultBlockingWebClient(WebClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public AggregatedHttpResponse execute(HttpRequest req, RequestOptions options) {
        if (options.exchangeType() == null) {
            options = options.toBuilder().exchangeType(ExchangeType.UNARY).build();
        }
        return ResponseAs.blocking().as(this.delegate.execute(req, options));
    }

    @Override
    public BlockingWebClientRequestPreparation prepare() {
        return new BlockingWebClientRequestPreparation(this.delegate.prepare());
    }

    @Override
    public Scheme scheme() {
        return this.delegate.scheme();
    }

    @Override
    public EndpointGroup endpointGroup() {
        return this.delegate.endpointGroup();
    }

    @Override
    public String absolutePathRef() {
        return this.delegate.absolutePathRef();
    }

    @Override
    public URI uri() {
        return this.delegate.uri();
    }

    @Override
    public Class<?> clientType() {
        return BlockingWebClient.class;
    }

    @Override
    public ClientOptions options() {
        return this.delegate.options();
    }

    @Override
    public HttpClient unwrap() {
        return this.delegate.unwrap();
    }

    @Override
    public Object unwrapAll() {
        return this.delegate.unwrapAll();
    }
}

