/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.client.ClientBuilderParams;
import karate.com.linecorp.armeria.client.ClientFactory;
import karate.com.linecorp.armeria.client.ClientFactoryOptions;
import karate.com.linecorp.armeria.client.ClientFactoryProvider;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.HttpClientFactory;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.common.Scheme;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.AsyncCloseable;
import karate.com.linecorp.armeria.common.util.AsyncCloseableSupport;
import karate.com.linecorp.armeria.common.util.ReleasableHolder;
import karate.com.linecorp.armeria.common.util.ShutdownHooks;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.resolver.AddressResolverGroup;
import karate.io.netty.util.ResourceLeakDetector;
import karate.io.netty.util.ResourceLeakDetectorFactory;
import karate.io.netty.util.ResourceLeakTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultClientFactory
implements ClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClientFactory.class);
    private static final ResourceLeakDetector<ClientFactory> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ClientFactory.class);
    private static volatile boolean shutdownHookDisabled;
    static final DefaultClientFactory DEFAULT;
    static final DefaultClientFactory INSECURE;
    private final HttpClientFactory httpClientFactory;
    private final Multimap<Scheme, ClientFactory> clientFactories;
    private final List<ClientFactory> clientFactoriesToClose;
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);
    @Nullable
    private final ResourceLeakTracker<ClientFactory> leakTracker = leakDetector.track(this);

    static void disableShutdownHook0() {
        shutdownHookDisabled = true;
    }

    DefaultClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
        ArrayList<HttpClientFactory> availableClientFactories = new ArrayList<HttpClientFactory>();
        Streams.stream(ServiceLoader.load(ClientFactoryProvider.class, DefaultClientFactory.class.getClassLoader())).map(provider -> provider.newFactory(httpClientFactory)).forEach(availableClientFactories::add);
        availableClientFactories.add(httpClientFactory);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (ClientFactory clientFactory : availableClientFactories) {
            clientFactory.supportedSchemes().forEach(s -> builder.put(s, f));
        }
        this.clientFactories = builder.build();
        this.clientFactoriesToClose = ImmutableList.copyOf(availableClientFactories).reverse();
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return this.clientFactories.keySet();
    }

    @Override
    public EventLoopGroup eventLoopGroup() {
        return this.httpClientFactory.eventLoopGroup();
    }

    @Override
    public Supplier<EventLoop> eventLoopSupplier() {
        return this.httpClientFactory.eventLoopSupplier();
    }

    @Override
    public ReleasableHolder<EventLoop> acquireEventLoop(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable Endpoint endpoint) {
        return this.httpClientFactory.acquireEventLoop(sessionProtocol, endpointGroup, endpoint);
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.httpClientFactory.meterRegistry();
    }

    @Override
    @Deprecated
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.httpClientFactory.setMeterRegistry(meterRegistry);
    }

    @Override
    public int numConnections() {
        return this.httpClientFactory.numConnections();
    }

    @Override
    public ClientFactoryOptions options() {
        return this.httpClientFactory.options();
    }

    @Override
    public Object newClient(ClientBuilderParams params) {
        if (this.isClosing()) {
            throw new IllegalStateException("Cannot create a client because the factory is closing.");
        }
        this.validateParams(params);
        Scheme scheme = params.scheme();
        Class<?> clientType = params.clientType();
        for (ClientFactory factory : this.clientFactories.get(scheme)) {
            if (!factory.isClientTypeSupported(clientType)) continue;
            return factory.newClient(params);
        }
        throw new IllegalStateException("No ClientFactory for scheme: " + scheme + " matched clientType: " + clientType);
    }

    @Override
    @Nullable
    public <T> T unwrap(Object client, Class<T> type) {
        T params = ClientFactory.super.unwrap(client, type);
        if (params != null) {
            return params;
        }
        for (ClientFactory factory : this.clientFactories.values()) {
            T p = factory.unwrap(client, type);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public ClientFactory unwrap() {
        return this.httpClientFactory;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> type) {
        Objects.requireNonNull(type, "type");
        T result = ClientFactory.super.as(type);
        if (result != null) {
            return result;
        }
        for (ClientFactory f : this.clientFactories.values()) {
            result = f.as(type);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean isClosing() {
        return this.closeable.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public CompletableFuture<?> whenClosed() {
        return this.closeable.whenClosed();
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.closeAsync(true);
    }

    CompletableFuture<?> closeAsync(boolean checkDefault) {
        if (checkDefault && this.checkDefault()) {
            return this.whenClosed();
        }
        return this.closeable.closeAsync();
    }

    private void closeAsync(CompletableFuture<?> future) {
        if (this.leakTracker != null) {
            this.leakTracker.close(this);
        }
        CompletableFuture[] delegateCloseFutures = (CompletableFuture[])this.clientFactoriesToClose.stream().map(AsyncCloseable::closeAsync).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(delegateCloseFutures).handle((unused, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
            } else {
                future.complete(null);
            }
            return null;
        });
    }

    @Override
    public void close() {
        if (this.checkDefault()) {
            return;
        }
        this.closeable.close();
    }

    @Override
    public CompletableFuture<Void> closeOnJvmShutdown(Runnable whenClosing) {
        Objects.requireNonNull(whenClosing, "whenClosing");
        return ShutdownHooks.addClosingTask(this, whenClosing);
    }

    private boolean checkDefault() {
        if (this == DEFAULT || this == INSECURE) {
            logger.debug("Refusing to close the default {}; must be closed via closeDefault()", (Object)ClientFactory.class.getSimpleName());
            return true;
        }
        return false;
    }

    AddressResolverGroup<InetSocketAddress> addressResolverGroup() {
        return this.httpClientFactory.addressResolverGroup();
    }

    static {
        DEFAULT = (DefaultClientFactory)ClientFactory.builder().build();
        INSECURE = (DefaultClientFactory)ClientFactory.builder().tlsNoVerify().build();
        if (DefaultClientFactory.class.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (!shutdownHookDisabled) {
                        ClientFactory.closeDefault();
                    }
                }));
            }
            catch (IllegalStateException e) {
                logger.debug("Skipped adding a shutdown hook to the DefaultClientFactory.", (Throwable)e);
            }
        }
    }
}

