/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import karate.com.linecorp.armeria.client.DnsCache;
import karate.com.linecorp.armeria.client.DnsCacheListener;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.common.metric.CaffeineMetricSupport;
import karate.com.linecorp.armeria.internal.common.util.CollectionUtil;
import karate.com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import karate.com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import karate.com.linecorp.armeria.internal.shaded.caffeine.cache.RemovalCause;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Objects;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.handler.codec.dns.DnsQuestion;
import karate.io.netty.handler.codec.dns.DnsRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultDnsCache
implements DnsCache {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDnsCache.class);
    private final List<DnsCacheListener> listeners = new CopyOnWriteArrayList<DnsCacheListener>();
    private final Cache<DnsQuestion, CacheEntry> cache;
    private final ScheduledExecutorService executor;
    private final int minTtl;
    private final int maxTtl;
    private final int negativeTtl;
    private boolean evictionWarned;

    DefaultDnsCache(String cacheSpec, MeterRegistry meterRegistry, ScheduledExecutorService executor, int minTtl, int maxTtl, int negativeTtl) {
        this.executor = executor;
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        this.negativeTtl = negativeTtl;
        this.cache = Caffeine.from(cacheSpec).removalListener((key, value, cause) -> {
            boolean evicted;
            if (value != null) {
                ((CacheEntry)value).scheduledFuture.cancel(true);
            }
            if (key == null || value == null) {
                return;
            }
            boolean bl = evicted = cause == RemovalCause.SIZE;
            if (evicted) {
                if (!this.evictionWarned) {
                    this.evictionWarned = true;
                    logger.warn("{} is evicted due to size. Please consider increasing the maximum size of the DNS cache. cache spec: {}", key, (Object)cacheSpec);
                } else {
                    logger.debug("{} is evicted due to {}.", key, (Object)cause);
                }
            }
            UnknownHostException reason = value.cause();
            List<DnsRecord> records = value.records();
            assert (records != null || reason != null);
            for (DnsCacheListener listener : this.listeners) {
                DefaultDnsCache.invokeListener(listener, evicted, key, records, reason);
            }
        }).executor(executor).build();
        MeterIdPrefix idPrefix = new MeterIdPrefix("armeria.client.dns.cache");
        CaffeineMetricSupport.setup(meterRegistry, idPrefix, this.cache);
    }

    private static void invokeListener(DnsCacheListener listener, boolean evicted, DnsQuestion question, @Nullable List<DnsRecord> records, @Nullable UnknownHostException reason) {
        try {
            if (evicted) {
                listener.onEviction(question, records, reason);
            } else {
                listener.onRemoval(question, records, reason);
            }
        }
        catch (Exception ex) {
            logger.warn("Unexpected exception while invoking {}", (Object)listener, (Object)ex);
        }
    }

    @Override
    public void cache(DnsQuestion question, Iterable<? extends DnsRecord> records) {
        java.util.Objects.requireNonNull(question, "question");
        java.util.Objects.requireNonNull(records, "records");
        if (this.maxTtl == 0) {
            return;
        }
        ImmutableList<DnsRecord> copied = ImmutableList.copyOf(records);
        long ttl = copied.stream().mapToLong(DnsRecord::timeToLive).min().orElse(this.minTtl);
        int effectiveTtl = Math.min(this.maxTtl, Math.max(this.minTtl, Ints.saturatedCast(ttl)));
        this.cache.put(question, new CacheEntry(this.cache, question, copied, null, this.executor, effectiveTtl));
    }

    @Override
    public void cache(DnsQuestion question, UnknownHostException cause) {
        java.util.Objects.requireNonNull(question, "question");
        java.util.Objects.requireNonNull(cause, "cause");
        if (this.negativeTtl > 0) {
            this.cache.put(question, new CacheEntry(this.cache, question, null, cause, this.executor, this.negativeTtl));
        }
    }

    @Override
    @Nullable
    public List<DnsRecord> get(DnsQuestion question) throws UnknownHostException {
        java.util.Objects.requireNonNull(question, "question");
        CacheEntry entry = this.cache.getIfPresent(question);
        if (entry == null) {
            return null;
        }
        UnknownHostException cause = entry.cause();
        if (cause != null) {
            throw cause;
        }
        return entry.records();
    }

    @Override
    public void remove(DnsQuestion question) {
        java.util.Objects.requireNonNull(question, "question");
        this.cache.invalidate(question);
    }

    @Override
    public void removeAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void addListener(DnsCacheListener listener) {
        java.util.Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
    }

    private static final class CacheEntry {
        @Nullable
        private final List<DnsRecord> records;
        @Nullable
        private final UnknownHostException cause;
        private final ScheduledFuture<?> scheduledFuture;
        int hashCode;

        CacheEntry(Cache<DnsQuestion, CacheEntry> cache, DnsQuestion question, @Nullable List<DnsRecord> records, @Nullable UnknownHostException cause, ScheduledExecutorService executor, int timeToLive) {
            assert (records != null || cause != null);
            this.records = records;
            this.cause = cause;
            this.scheduledFuture = executor.schedule(() -> cache.asMap().remove(question, this), (long)timeToLive, TimeUnit.SECONDS);
        }

        @Nullable
        List<DnsRecord> records() {
            return this.records;
        }

        @Nullable
        UnknownHostException cause() {
            return this.cause;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheEntry)) {
                return false;
            }
            CacheEntry that = (CacheEntry)o;
            return Objects.equal(this.records, that.records) && Objects.equal(this.cause, that.cause) && this.scheduledFuture.equals(that.scheduledFuture);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hashCode = this.scheduledFuture.hashCode();
                if (this.records != null) {
                    hashCode = hashCode * 31 + this.records.hashCode();
                }
                if (this.cause != null) {
                    hashCode = hashCode * 31 + this.cause.hashCode();
                }
                this.hashCode = hashCode;
                return this.hashCode;
            }
            return this.hashCode;
        }

        public String toString() {
            MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper(this).omitNullValues().add("cause", this.cause).add("scheduledFuture", this.scheduledFuture);
            if (this.records != null) {
                builder.add("records", CollectionUtil.truncate(this.records, 10)).add("numRecords", this.records.size());
            }
            return builder.toString();
        }
    }
}

