/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.stream.Collectors;
import karate.com.linecorp.armeria.client.DnsTimeoutException;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.common.util.StringUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.micrometer.core.instrument.Tag;
import karate.io.micrometer.core.instrument.Tags;
import karate.io.netty.channel.ChannelFuture;
import karate.io.netty.handler.codec.dns.DnsQuestion;
import karate.io.netty.handler.codec.dns.DnsResponseCode;
import karate.io.netty.resolver.dns.DnsNameResolverTimeoutException;
import karate.io.netty.resolver.dns.DnsQueryLifecycleObserver;

final class DefaultDnsQueryLifecycleObserver
implements DnsQueryLifecycleObserver {
    private static final String NAME_TAG = "name";
    private static final String RESULT_TAG = "result";
    private static final String SERVERS_TAG = "servers";
    private static final String SERVER_TAG = "server";
    private static final String CODE_TAG = "code";
    private static final String CAUSE_TAG = "cause";
    private static final String CNAME_TAG = "cname";
    private static final String NXDOMAIN_EXCEPTION_MESSAGE = "NXDOMAIN";
    private static final String CNAME_EXCEPTION_MESSAGE = "CNAME";
    private static final String NO_MATCHING_EXCEPTION_MESSAGE = "No matching record";
    private static final String UNRECOGNIZED_TYPE_EXCEPTION_MESSAGE = "unrecognized";
    private static final String NO_NS_RETURNED_EXCEPTION_MESSAGE = "No name servers";
    private static final Tag TAG_SUCCESS = Tag.of("result", "success");
    private static final Tag TAG_FAILURE = Tag.of("result", "failure");
    private final MeterRegistry meterRegistry;
    private final MeterIdPrefix meterIdPrefix;
    private final Tag nameTag;
    private final String meterIdPrefixWritten;
    private final String meterIdPrefixCancelled;
    private final String meterIdPrefixRedirected;
    private final String meterIdPrefixCnamed;
    private final String meterIdPrefixNoAnswer;

    DefaultDnsQueryLifecycleObserver(MeterRegistry meterRegistry, DnsQuestion question, MeterIdPrefix prefix) {
        this.meterRegistry = meterRegistry;
        this.meterIdPrefix = prefix;
        this.nameTag = Tag.of(NAME_TAG, question.name());
        this.meterIdPrefixWritten = this.meterIdPrefix.name() + ".written";
        this.meterIdPrefixCancelled = this.meterIdPrefix.name() + ".cancelled";
        this.meterIdPrefixRedirected = this.meterIdPrefix.name() + ".redirected";
        this.meterIdPrefixCnamed = this.meterIdPrefix.name() + ".cnamed";
        this.meterIdPrefixNoAnswer = this.meterIdPrefix.name() + ".noanswer";
    }

    @Override
    public void queryWritten(InetSocketAddress dnsServerAddress, ChannelFuture future) {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of(SERVER_TAG, DefaultDnsQueryLifecycleObserver.getHostAddress(dnsServerAddress)));
        this.meterRegistry.counter(this.meterIdPrefixWritten, tags).increment();
    }

    @Override
    public void queryCancelled(int queriesRemaining) {
        this.meterRegistry.counter(this.meterIdPrefixCancelled, Tags.of(this.nameTag)).increment();
    }

    @Override
    public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
        String servers = nameServers.stream().map(DefaultDnsQueryLifecycleObserver::getHostAddress).collect(Collectors.joining(","));
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of(SERVERS_TAG, servers));
        this.meterRegistry.counter(this.meterIdPrefixRedirected, tags).increment();
        return this;
    }

    private static String getHostAddress(InetSocketAddress addr) {
        String value = addr.getAddress().getHostAddress();
        int percentIdx = value.indexOf(37);
        return percentIdx < 0 ? value : value.substring(0, percentIdx);
    }

    @Override
    public DnsQueryLifecycleObserver queryCNAMEd(DnsQuestion cnameQuestion) {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of(CNAME_TAG, cnameQuestion.name()));
        this.meterRegistry.counter(this.meterIdPrefixCnamed, tags).increment();
        return this;
    }

    @Override
    public DnsQueryLifecycleObserver queryNoAnswer(DnsResponseCode code) {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, Tag.of(CODE_TAG, StringUtil.toString(code.intValue())));
        this.meterRegistry.counter(this.meterIdPrefixNoAnswer, tags).increment();
        return this;
    }

    @Override
    public void queryFailed(Throwable cause) {
        String message = cause.getMessage();
        if (message == null || !message.contains(NO_NS_RETURNED_EXCEPTION_MESSAGE)) {
            ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, TAG_FAILURE, Tag.of(CAUSE_TAG, DefaultDnsQueryLifecycleObserver.determineDnsExceptionTag((Throwable)cause, (String)message).lowerCasedName));
            this.meterRegistry.counter(this.meterIdPrefix.name(), tags).increment();
        }
    }

    @Override
    public void querySucceed() {
        ImmutableList<Tag> tags = ImmutableList.of(this.nameTag, TAG_SUCCESS, Tag.of(CAUSE_TAG, "none"));
        this.meterRegistry.counter(this.meterIdPrefix.name(), tags).increment();
    }

    private static DnsExceptionTypes determineDnsExceptionTag(Throwable cause, @Nullable String message) {
        if (cause instanceof DnsTimeoutException) {
            return DnsExceptionTypes.SERVER_TIMEOUT;
        }
        if (cause instanceof DnsNameResolverTimeoutException) {
            return DnsExceptionTypes.RESOLVER_TIMEOUT;
        }
        if (message == null) {
            return DnsExceptionTypes.OTHERS;
        }
        if (message.contains(NXDOMAIN_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.NX_DOMAIN;
        }
        if (message.contains(CNAME_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.CNAME_NOT_FOUND;
        }
        if (message.contains(NO_MATCHING_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.NO_MATCHING_RECORD;
        }
        if (message.contains(UNRECOGNIZED_TYPE_EXCEPTION_MESSAGE)) {
            return DnsExceptionTypes.UNRECOGNIZED_TYPE;
        }
        return DnsExceptionTypes.OTHERS;
    }

    private static enum DnsExceptionTypes {
        NX_DOMAIN,
        CNAME_NOT_FOUND,
        NO_MATCHING_RECORD,
        UNRECOGNIZED_TYPE,
        OTHERS,
        SERVER_TIMEOUT,
        RESOLVER_TIMEOUT;

        final String lowerCasedName = Ascii.toLowerCase(this.name());
    }
}

