/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.util.Objects;
import karate.com.linecorp.armeria.client.BlockingWebClient;
import karate.com.linecorp.armeria.client.ClientBuilderParams;
import karate.com.linecorp.armeria.client.Clients;
import karate.com.linecorp.armeria.client.DefaultBlockingWebClient;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.RequestOptions;
import karate.com.linecorp.armeria.client.RestClient;
import karate.com.linecorp.armeria.client.UserClient;
import karate.com.linecorp.armeria.client.WebClient;
import karate.com.linecorp.armeria.client.WebClientBuilder;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.RequestTarget;
import karate.com.linecorp.armeria.common.RequestTargetForm;
import karate.com.linecorp.armeria.common.Scheme;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Strings;
import karate.io.micrometer.core.instrument.MeterRegistry;

final class DefaultWebClient
extends UserClient<HttpRequest, HttpResponse>
implements WebClient {
    static final WebClient DEFAULT = new WebClientBuilder().build();
    static final RequestOptions RESPONSE_STREAMING_REQUEST_OPTIONS = RequestOptions.builder().exchangeType(ExchangeType.RESPONSE_STREAMING).build();
    @Nullable
    private BlockingWebClient blockingWebClient;
    @Nullable
    private RestClient restClient;

    DefaultWebClient(ClientBuilderParams params, HttpClient delegate, MeterRegistry meterRegistry) {
        super(params, delegate, meterRegistry, HttpResponse::of, (ctx, cause) -> HttpResponse.ofFailure(cause));
    }

    @Override
    public HttpResponse execute(HttpRequest req, RequestOptions requestOptions) {
        String newPath;
        SessionProtocol protocol;
        EndpointGroup endpointGroup;
        Objects.requireNonNull(req, "req");
        Objects.requireNonNull(requestOptions, "requestOptions");
        String originalPath = req.path();
        String prefix = Strings.emptyToNull(this.uri().getRawPath());
        RequestTarget reqTarget = RequestTarget.forClient(originalPath, prefix);
        if (reqTarget == null) {
            return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Invalid request target: " + originalPath));
        }
        if (Clients.isUndefinedUri(this.uri())) {
            String authority;
            String scheme;
            if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
                scheme = reqTarget.scheme();
                authority = reqTarget.authority();
                assert (scheme != null);
                assert (authority != null);
            } else {
                scheme = req.scheme();
                authority = req.authority();
                if (scheme == null || authority == null) {
                    return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Scheme and authority must be specified in \":path\" or in \":scheme\" and \":authority\". :path=" + originalPath + ", :scheme=" + req.scheme() + ", :authority=" + req.authority()));
                }
            }
            endpointGroup = Endpoint.parse(authority);
            try {
                protocol = Scheme.parse(scheme).sessionProtocol();
            }
            catch (Exception e) {
                return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Failed to parse a scheme: " + reqTarget.scheme(), e));
            }
        } else {
            if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
                return DefaultWebClient.abortRequestAndReturnFailureResponse(req, new IllegalArgumentException("Cannot send a request with a \":path\" header that contains an authority, because the client was created with a base URI. path: " + originalPath));
            }
            endpointGroup = this.endpointGroup();
            protocol = this.scheme().sessionProtocol();
        }
        HttpRequest newReq = (newPath = reqTarget.pathAndQuery()).equals(originalPath) ? req : req.withHeaders(req.headers().toBuilder().path(newPath));
        return (HttpResponse)this.execute(protocol, endpointGroup, newReq.method(), reqTarget, newReq, requestOptions);
    }

    private static HttpResponse abortRequestAndReturnFailureResponse(HttpRequest req, IllegalArgumentException cause) {
        req.abort(cause);
        return HttpResponse.ofFailure(cause);
    }

    @Override
    public BlockingWebClient blocking() {
        if (this.blockingWebClient != null) {
            return this.blockingWebClient;
        }
        this.blockingWebClient = new DefaultBlockingWebClient(this);
        return this.blockingWebClient;
    }

    @Override
    public RestClient asRestClient() {
        if (this.restClient != null) {
            return this.restClient;
        }
        this.restClient = RestClient.of(this);
        return this.restClient;
    }

    @Override
    public HttpClient unwrap() {
        return (HttpClient)super.unwrap();
    }
}

