/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import karate.com.linecorp.armeria.client.DnsCacheBuilder;
import karate.com.linecorp.armeria.client.DnsCacheListener;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.netty.handler.codec.dns.DnsQuestion;
import karate.io.netty.handler.codec.dns.DnsRecord;

@UnstableApi
public interface DnsCache {
    public static DnsCache ofDefault() {
        return DnsCacheBuilder.DEFAULT_CACHE;
    }

    public static DnsCache of(String cacheSpec) {
        return DnsCache.builder().cacheSpec(cacheSpec).build();
    }

    public static DnsCacheBuilder builder() {
        return new DnsCacheBuilder();
    }

    default public void cache(DnsQuestion question, DnsRecord ... records) {
        Objects.requireNonNull(question, "question");
        Objects.requireNonNull(records, "record");
        this.cache(question, ImmutableList.copyOf(records));
    }

    public void cache(DnsQuestion var1, Iterable<? extends DnsRecord> var2);

    public void cache(DnsQuestion var1, UnknownHostException var2);

    @Nullable
    public List<DnsRecord> get(DnsQuestion var1) throws UnknownHostException;

    public void remove(DnsQuestion var1);

    public void removeAll();

    public void addListener(DnsCacheListener var1);
}

