/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.time.Duration;
import java.util.Objects;
import java.util.function.ToLongFunction;
import karate.com.linecorp.armeria.client.AbstractDnsResolverBuilder;
import karate.com.linecorp.armeria.client.RefreshingAddressResolverGroup;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.resolver.ResolvedAddressTypes;

public final class DnsResolverGroupBuilder
extends AbstractDnsResolverBuilder<DnsResolverGroupBuilder> {
    static final ToLongFunction<String> DEFAULT_AUTO_REFRESH_TIMEOUT_FUNCTION = hostname -> Long.MAX_VALUE;
    @Nullable
    private ResolvedAddressTypes resolvedAddressTypes;
    private boolean autoRefresh = true;
    @Nullable
    private Backoff autoRefreshBackoff;
    @Nullable
    private ToLongFunction<String> autoRefreshTimeoutFunction;

    DnsResolverGroupBuilder() {
    }

    @Deprecated
    public DnsResolverGroupBuilder refreshBackoff(Backoff refreshBackoff) {
        return this.autoRefreshBackoff(refreshBackoff);
    }

    public DnsResolverGroupBuilder resolvedAddressTypes(ResolvedAddressTypes resolvedAddressTypes) {
        this.resolvedAddressTypes = Objects.requireNonNull(resolvedAddressTypes, "resolvedAddressTypes");
        return this;
    }

    @UnstableApi
    public DnsResolverGroupBuilder enableAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        return this;
    }

    public DnsResolverGroupBuilder autoRefreshBackoff(Backoff refreshBackoff) {
        this.autoRefreshBackoff = Objects.requireNonNull(refreshBackoff, "refreshBackoff");
        return this;
    }

    @UnstableApi
    public DnsResolverGroupBuilder autoRefreshTimeout(ToLongFunction<? super String> timeoutFunction) {
        Objects.requireNonNull(timeoutFunction, "timeoutFunction");
        this.autoRefreshTimeoutFunction = timeoutFunction;
        return this;
    }

    @UnstableApi
    public DnsResolverGroupBuilder autoRefreshTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.autoRefreshTimeoutMillis(timeout.toMillis());
    }

    @UnstableApi
    public DnsResolverGroupBuilder autoRefreshTimeoutMillis(long timeoutMillis) {
        Preconditions.checkArgument(timeoutMillis >= 0L, "timeoutMillis: %s (expected: >= 0)", timeoutMillis);
        long adjustedTimeoutMillis = timeoutMillis == 0L ? Long.MAX_VALUE : timeoutMillis;
        return this.autoRefreshTimeout((? super String hostname) -> adjustedTimeoutMillis);
    }

    @Nullable
    MeterRegistry meterRegistry0() {
        return this.meterRegistry();
    }

    RefreshingAddressResolverGroup build(EventLoopGroup eventLoopGroup) {
        ToLongFunction<String> autoRefreshTimeoutFunction = this.autoRefreshTimeoutFunction;
        Backoff autoRefreshBackoff = this.autoRefreshBackoff;
        if (!(this.autoRefresh || autoRefreshTimeoutFunction == null && autoRefreshBackoff == null)) {
            throw new IllegalStateException("Can't set 'autoRefreshTimeout()' or 'autoRefreshBackoff()' if 'autoRefresh' is disabled");
        }
        if (this.autoRefresh) {
            if (autoRefreshTimeoutFunction == null) {
                autoRefreshTimeoutFunction = DEFAULT_AUTO_REFRESH_TIMEOUT_FUNCTION;
            }
            if (autoRefreshBackoff == null) {
                autoRefreshBackoff = Backoff.ofDefault();
            }
        }
        return new RefreshingAddressResolverGroup(this.cacheSpec(), this.negativeTtl(), this.resolvedAddressTypes, this.maybeCreateDnsCache(), this.autoRefresh, autoRefreshBackoff, autoRefreshTimeoutFunction, this.searchDomains(), this.ndots(), this.queryTimeoutMillis(), this.hostsFileEntriesResolver(), this.buildConfigurator(eventLoopGroup));
    }
}

