/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import karate.com.linecorp.armeria.client.Http2ClientKeepAliveHandler;
import karate.com.linecorp.armeria.client.Http2ResponseDecoder;
import karate.com.linecorp.armeria.client.HttpClientFactory;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.metric.MoreMeters;
import karate.com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandler;
import karate.com.linecorp.armeria.internal.common.KeepAliveHandler;
import karate.com.linecorp.armeria.internal.common.KeepAliveHandlerUtil;
import karate.com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.micrometer.core.instrument.Tag;
import karate.io.micrometer.core.instrument.Timer;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import karate.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import karate.io.netty.handler.codec.http2.Http2Settings;

final class Http2ClientConnectionHandler
extends AbstractHttp2ConnectionHandler {
    private final Http2ResponseDecoder responseDecoder;

    Http2ClientConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, Channel channel, HttpClientFactory clientFactory, SessionProtocol protocol) {
        super(decoder, encoder, initialSettings, Http2ClientConnectionHandler.newKeepAliveHandler(encoder, channel, clientFactory, protocol));
        this.responseDecoder = new Http2ResponseDecoder(channel, this.encoder(), clientFactory, this.keepAliveHandler());
        this.connection().addListener(this.responseDecoder);
        this.decoder().frameListener(this.responseDecoder);
    }

    private static KeepAliveHandler newKeepAliveHandler(Http2ConnectionEncoder encoder, Channel channel, HttpClientFactory clientFactory, SessionProtocol protocol) {
        int maxNumRequestsPerConnection;
        long maxConnectionAgeMillis;
        long idleTimeoutMillis = clientFactory.idleTimeoutMillis();
        boolean keepAliveOnPing = clientFactory.keepAliveOnPing();
        long pingIntervalMillis = clientFactory.pingIntervalMillis();
        boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis = clientFactory.maxConnectionAgeMillis(), maxNumRequestsPerConnection = clientFactory.maxNumRequestsPerConnection());
        if (!needsKeepAliveHandler) {
            return new NoopKeepAliveHandler();
        }
        Timer keepAliveTimer = MoreMeters.newTimer(clientFactory.meterRegistry(), "armeria.client.connections.lifespan", ImmutableList.of(Tag.of("protocol", protocol.uriText())));
        return new Http2ClientKeepAliveHandler(channel, encoder.frameWriter(), keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection, keepAliveOnPing);
    }

    Http2ResponseDecoder responseDecoder() {
        return this.responseDecoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.handlerAdded(ctx);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.handlerRemoved0(ctx);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelRegistered(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelActive(ctx);
        ctx.flush();
    }

    @Override
    protected boolean needsImmediateDisconnection() {
        return this.responseDecoder.goAwayHandler().receivedErrorGoAway() || this.keepAliveHandler().isClosing();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.channelInactive(ctx);
    }

    private void maybeInitializeKeepAliveHandler(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.keepAliveHandler().initialize(ctx);
        }
    }

    private void destroyKeepAliveHandler() {
        this.keepAliveHandler().destroy();
    }
}

