/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import karate.com.linecorp.armeria.client.Http2ClientConnectionHandler;
import karate.com.linecorp.armeria.client.HttpClientFactory;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandlerBuilder;
import karate.io.netty.channel.Channel;
import karate.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import karate.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import karate.io.netty.handler.codec.http2.Http2Settings;

final class Http2ClientConnectionHandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2ClientConnectionHandler, Http2ClientConnectionHandlerBuilder> {
    private final HttpClientFactory clientFactory;
    private final SessionProtocol protocol;

    Http2ClientConnectionHandlerBuilder(Channel ch, HttpClientFactory clientFactory, SessionProtocol protocol) {
        super(ch);
        this.clientFactory = clientFactory;
        this.protocol = protocol;
        this.decoderEnforceMaxRstFramesPerWindow(0, 0);
        long gracefulShutdownTimeoutMillis = clientFactory.http2GracefulShutdownTimeoutMillis();
        if (gracefulShutdownTimeoutMillis == Long.MAX_VALUE) {
            this.gracefulShutdownTimeoutMillis(-1L);
        } else {
            this.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
        }
    }

    @Override
    protected Http2ClientConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        return new Http2ClientConnectionHandler(decoder, encoder, initialSettings, this.channel(), this.clientFactory, this.protocol);
    }
}

