/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.HttpChannelPool;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.HttpClientFactory;
import karate.com.linecorp.armeria.client.UnprocessedRequestException;
import karate.com.linecorp.armeria.client.endpoint.EmptyEndpointGroupException;
import karate.com.linecorp.armeria.client.proxy.HAProxyConfig;
import karate.com.linecorp.armeria.client.proxy.ProxyConfig;
import karate.com.linecorp.armeria.client.proxy.ProxyType;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.SerializationFormat;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.ClientConnectionTimings;
import karate.com.linecorp.armeria.common.logging.ClientConnectionTimingsBuilder;
import karate.com.linecorp.armeria.common.util.SafeCloseable;
import karate.com.linecorp.armeria.internal.client.ClientPendingThrowableUtil;
import karate.com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import karate.com.linecorp.armeria.internal.client.DecodedHttpResponse;
import karate.com.linecorp.armeria.internal.client.HttpSession;
import karate.com.linecorp.armeria.internal.client.PooledChannel;
import karate.com.linecorp.armeria.internal.common.RequestContextUtil;
import karate.com.linecorp.armeria.server.ProxiedAddresses;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.resolver.AddressResolverGroup;
import karate.io.netty.util.concurrent.Future;

final class HttpClientDelegate
implements HttpClient {
    private final HttpClientFactory factory;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;

    HttpClientDelegate(HttpClientFactory factory, AddressResolverGroup<InetSocketAddress> addressResolverGroup) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.addressResolverGroup = Objects.requireNonNull(addressResolverGroup, "addressResolverGroup");
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        ProxyConfig proxyConfig;
        Throwable throwable = ClientPendingThrowableUtil.pendingThrowable(ctx);
        if (throwable != null) {
            return HttpClientDelegate.earlyFailedResponse(throwable, ctx);
        }
        if (req != ctx.request()) {
            return HttpClientDelegate.earlyFailedResponse(new IllegalStateException("ctx.request() does not match the actual request; did you forget to call ctx.updateRequest() in your decorator?"), ctx);
        }
        Endpoint endpoint = ctx.endpoint();
        if (endpoint == null) {
            return HttpClientDelegate.earlyFailedResponse(EmptyEndpointGroupException.get(ctx.endpointGroup()), ctx);
        }
        SessionProtocol protocol = ctx.sessionProtocol();
        try {
            proxyConfig = this.getProxyConfig(protocol, endpoint);
        }
        catch (Throwable t) {
            return HttpClientDelegate.earlyFailedResponse(t, ctx);
        }
        Throwable cancellationCause = ctx.cancellationCause();
        if (cancellationCause != null) {
            return HttpClientDelegate.earlyFailedResponse(cancellationCause, ctx);
        }
        Endpoint endpointWithPort = endpoint.withDefaultPort(ctx.sessionProtocol());
        EventLoop eventLoop = ctx.eventLoop().withoutContext();
        DecodedHttpResponse res = new DecodedHttpResponse(eventLoop);
        HttpClientDelegate.updateCancellationTask(ctx, req, res);
        ClientConnectionTimingsBuilder timingsBuilder = ClientConnectionTimings.builder();
        if (endpointWithPort.hasIpAddr() || proxyConfig.proxyType().isForwardProxy()) {
            this.acquireConnectionAndExecute(ctx, endpointWithPort, req, res, timingsBuilder, proxyConfig);
        } else {
            this.resolveAddress(endpointWithPort, ctx, (resolved, cause) -> {
                timingsBuilder.dnsResolutionEnd();
                if (cause == null) {
                    assert (resolved != null);
                    this.acquireConnectionAndExecute(ctx, (Endpoint)resolved, req, res, timingsBuilder, proxyConfig);
                } else {
                    ctx.logBuilder().session(null, ctx.sessionProtocol(), timingsBuilder.build());
                    ctx.cancel((Throwable)cause);
                }
            });
        }
        return res;
    }

    private static void updateCancellationTask(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        ClientRequestContextExtension ctxExt = ctx.as(ClientRequestContextExtension.class);
        if (ctxExt == null) {
            return;
        }
        ctxExt.responseCancellationScheduler().updateTask(cause -> {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                UnprocessedRequestException ure = UnprocessedRequestException.of(cause);
                req.abort(ure);
                ctx.logBuilder().endRequest(ure);
                res.close(ure);
                ctx.logBuilder().endResponse(ure);
            }
        });
    }

    private void resolveAddress(Endpoint endpoint, ClientRequestContext ctx, BiConsumer<@Nullable Endpoint, @Nullable Throwable> onComplete) {
        assert (!endpoint.hasIpAddr() && endpoint.hasPort());
        Future<InetSocketAddress> resolveFuture = this.addressResolverGroup.getResolver(ctx.eventLoop().withoutContext()).resolve(endpoint.toSocketAddress(-1));
        if (resolveFuture.isSuccess()) {
            InetAddress address = resolveFuture.getNow().getAddress();
            onComplete.accept(endpoint.withInetAddress(address), null);
        } else {
            resolveFuture.addListener(future -> {
                if (future.isSuccess()) {
                    InetAddress address = ((InetSocketAddress)resolveFuture.getNow()).getAddress();
                    onComplete.accept(endpoint.withInetAddress(address), null);
                } else {
                    onComplete.accept(null, resolveFuture.cause());
                }
            });
        }
    }

    private void acquireConnectionAndExecute(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        if (ctx.eventLoop().inEventLoop()) {
            this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig);
        } else {
            ctx.eventLoop().execute(() -> this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig));
        }
    }

    private void acquireConnectionAndExecute0(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        HttpChannelPool pool;
        HttpChannelPool.PoolKey key = new HttpChannelPool.PoolKey(endpoint, proxyConfig);
        try {
            pool = this.factory.pool(ctx.eventLoop().withoutContext());
        }
        catch (Throwable t) {
            ctx.cancel(t);
            return;
        }
        SessionProtocol protocol = ctx.sessionProtocol();
        SerializationFormat serializationFormat = ctx.log().partial().serializationFormat();
        PooledChannel pooledChannel = pool.acquireNow(protocol, serializationFormat, key);
        if (pooledChannel != null) {
            HttpClientDelegate.logSession(ctx, pooledChannel, null);
            HttpClientDelegate.doExecute(pooledChannel, ctx, req, res);
        } else {
            pool.acquireLater(protocol, serializationFormat, key, timingsBuilder).handle((newPooledChannel, cause) -> {
                HttpClientDelegate.logSession(ctx, newPooledChannel, timingsBuilder.build());
                if (cause == null) {
                    HttpClientDelegate.doExecute(newPooledChannel, ctx, req, res);
                } else {
                    ctx.cancel((Throwable)cause);
                }
                return null;
            });
        }
    }

    private ProxyConfig getProxyConfig(SessionProtocol protocol, Endpoint endpoint) {
        ProxyConfig proxyConfig = this.factory.proxyConfigSelector().select(protocol, endpoint);
        Objects.requireNonNull(proxyConfig, "proxyConfig");
        if (proxyConfig.proxyType() == ProxyType.HAPROXY && ((HAProxyConfig)proxyConfig).sourceAddress() == null) {
            InetSocketAddress proxyAddress = proxyConfig.proxyAddress();
            assert (proxyAddress != null);
            ServiceRequestContext serviceCtx = ServiceRequestContext.currentOrNull();
            if (serviceCtx != null) {
                ProxiedAddresses proxiedAddresses = serviceCtx.proxiedAddresses();
                return ProxyConfig.haproxy(proxyAddress, proxiedAddresses.sourceAddress());
            }
        }
        return proxyConfig;
    }

    private static void logSession(ClientRequestContext ctx, @Nullable PooledChannel pooledChannel, @Nullable ClientConnectionTimings connectionTimings) {
        if (pooledChannel != null) {
            Channel channel = pooledChannel.get();
            SessionProtocol actualProtocol = pooledChannel.protocol();
            ctx.logBuilder().session(channel, actualProtocol, connectionTimings);
        } else {
            ctx.logBuilder().session(null, ctx.sessionProtocol(), connectionTimings);
        }
    }

    private static HttpResponse earlyFailedResponse(Throwable t, ClientRequestContext ctx) {
        UnprocessedRequestException cause = UnprocessedRequestException.of(t);
        ctx.cancel(cause);
        return HttpResponse.ofFailure(cause);
    }

    private static void doExecute(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        Channel channel = pooledChannel.get();
        HttpSession session = HttpSession.get(channel);
        res.init(session.inboundTrafficController());
        session.invoke(pooledChannel, ctx, req, res);
    }
}

