/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import karate.com.linecorp.armeria.client.ClientOptions;
import karate.com.linecorp.armeria.client.Http1ResponseDecoder;
import karate.com.linecorp.armeria.client.Http2ClientConnectionHandler;
import karate.com.linecorp.armeria.client.Http2ClientConnectionHandlerBuilder;
import karate.com.linecorp.armeria.client.Http2ResponseDecoder;
import karate.com.linecorp.armeria.client.HttpChannelPool;
import karate.com.linecorp.armeria.client.HttpClientFactory;
import karate.com.linecorp.armeria.client.HttpSessionHandler;
import karate.com.linecorp.armeria.client.PreTlsHandshakeException;
import karate.com.linecorp.armeria.client.RequestOptions;
import karate.com.linecorp.armeria.client.SessionProtocolNegotiationCache;
import karate.com.linecorp.armeria.client.SessionProtocolNegotiationException;
import karate.com.linecorp.armeria.client.WebSocketHttp1ClientChannelHandler;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.RequestId;
import karate.com.linecorp.armeria.common.RequestTarget;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.ClientConnectionTimingsBuilder;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.common.util.SystemInfo;
import karate.com.linecorp.armeria.internal.client.DecodedHttpResponse;
import karate.com.linecorp.armeria.internal.client.DefaultClientRequestContext;
import karate.com.linecorp.armeria.internal.client.HttpSession;
import karate.com.linecorp.armeria.internal.client.PendingExceptionUtil;
import karate.com.linecorp.armeria.internal.client.UserAgentUtil;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttp2HeadersDecoder;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.common.CancellationScheduler;
import karate.com.linecorp.armeria.internal.common.ReadSuppressingHandler;
import karate.com.linecorp.armeria.internal.common.TrafficLoggingHandler;
import karate.com.linecorp.armeria.internal.common.util.ChannelUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelDuplexHandler;
import karate.io.netty.channel.ChannelHandler;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelInboundHandlerAdapter;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.ChannelPromise;
import karate.io.netty.channel.unix.DomainSocketAddress;
import karate.io.netty.handler.codec.ByteToMessageDecoder;
import karate.io.netty.handler.codec.DecoderException;
import karate.io.netty.handler.codec.http.DefaultFullHttpRequest;
import karate.io.netty.handler.codec.http.FullHttpRequest;
import karate.io.netty.handler.codec.http.HttpClientCodec;
import karate.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import karate.io.netty.handler.codec.http.HttpContent;
import karate.io.netty.handler.codec.http.HttpHeaderNames;
import karate.io.netty.handler.codec.http.HttpHeaders;
import karate.io.netty.handler.codec.http.HttpMethod;
import karate.io.netty.handler.codec.http.HttpResponse;
import karate.io.netty.handler.codec.http.HttpResponseStatus;
import karate.io.netty.handler.codec.http.HttpUtil;
import karate.io.netty.handler.codec.http.HttpVersion;
import karate.io.netty.handler.codec.http.LastHttpContent;
import karate.io.netty.handler.codec.http2.DefaultHttp2Connection;
import karate.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import karate.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import karate.io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import karate.io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import karate.io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import karate.io.netty.handler.codec.http2.Http2CodecUtil;
import karate.io.netty.handler.codec.http2.Http2Connection;
import karate.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import karate.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import karate.io.netty.handler.codec.http2.Http2Exception;
import karate.io.netty.handler.codec.http2.Http2FrameLogger;
import karate.io.netty.handler.codec.http2.Http2FrameReader;
import karate.io.netty.handler.codec.http2.Http2FrameWriter;
import karate.io.netty.handler.codec.http2.Http2InboundFrameLogger;
import karate.io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import karate.io.netty.handler.codec.http2.Http2Settings;
import karate.io.netty.handler.flush.FlushConsolidationHandler;
import karate.io.netty.handler.logging.LogLevel;
import karate.io.netty.handler.ssl.SslContext;
import karate.io.netty.handler.ssl.SslHandler;
import karate.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import karate.io.netty.util.AsciiString;
import karate.io.netty.util.ReferenceCountUtil;
import karate.io.netty.util.concurrent.Future;
import karate.io.netty.util.concurrent.GenericFutureListener;
import karate.org.reactivestreams.Subscriber;
import karate.org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpClientPipelineConfigurator
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientPipelineConfigurator.class);
    private static final Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.TRACE, "karate.com.linecorp.armeria.logging.traffic.client.http2");
    private static final long UPGRADE_RESPONSE_MAX_LENGTH = 16384L;
    private static final RequestOptions REQUEST_OPTIONS_FOR_UPGRADE_REQUEST = RequestOptions.builder().responseTimeoutMillis(0L).maxResponseLength(16384L).build();
    private static final RequestTarget REQ_TARGET_ASTERISK;
    private final HttpClientFactory clientFactory;
    private final boolean webSocket;
    @Nullable
    private final SslContext sslCtx;
    private final HttpPreference httpPreference;
    @Nullable
    private SocketAddress remoteAddress;
    private final SessionProtocol http1;
    private final SessionProtocol http2;

    HttpClientPipelineConfigurator(HttpClientFactory clientFactory, boolean webSocket, SessionProtocol sessionProtocol, SslContext sslCtx) {
        this.clientFactory = clientFactory;
        this.webSocket = webSocket;
        if (sessionProtocol == SessionProtocol.HTTP || sessionProtocol == SessionProtocol.HTTPS) {
            this.httpPreference = HttpPreference.HTTP2_PREFERRED;
        } else if (sessionProtocol == SessionProtocol.H1 || sessionProtocol == SessionProtocol.H1C) {
            this.httpPreference = HttpPreference.HTTP1_REQUIRED;
        } else if (sessionProtocol == SessionProtocol.H2 || sessionProtocol == SessionProtocol.H2C) {
            this.httpPreference = HttpPreference.HTTP2_REQUIRED;
        } else {
            throw new Error();
        }
        if (sessionProtocol.isTls()) {
            this.sslCtx = sslCtx;
            this.http1 = SessionProtocol.H1;
            this.http2 = SessionProtocol.H2;
        } else {
            this.sslCtx = null;
            this.http1 = SessionProtocol.H1C;
            this.http2 = SessionProtocol.H2C;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise connectionPromise) throws Exception {
        this.remoteAddress = remoteAddress;
        Channel ch = ctx.channel();
        ChannelUtil.disableWriterBufferWatermark(ch);
        ChannelPipeline p = ch.pipeline();
        p.addLast(new FlushConsolidationHandler());
        p.addLast(ReadSuppressingAndChannelDeactivatingHandler.INSTANCE);
        try {
            if (this.isHttps()) {
                this.configureAsHttps(ch, remoteAddress);
            } else {
                this.configureAsHttp(ch, connectionPromise);
            }
        }
        catch (Throwable t) {
            connectionPromise.tryFailure(t);
            ctx.close();
            return;
        }
        finally {
            if (p.context(this) != null) {
                p.remove(this);
            }
        }
        ctx.connect(remoteAddress, localAddress, connectionPromise);
    }

    private void configureAsHttps(final Channel ch, SocketAddress remoteAddr) {
        SSLEngine sslEngine;
        assert (this.sslCtx != null);
        final ChannelPipeline p = ch.pipeline();
        if (remoteAddr instanceof InetSocketAddress) {
            InetSocketAddress raddr = (InetSocketAddress)remoteAddr;
            sslEngine = this.sslCtx.newEngine(ch.alloc(), raddr.getHostString(), raddr.getPort());
        } else {
            assert (remoteAddr instanceof DomainSocketAddress) : remoteAddr;
            sslEngine = this.sslCtx.newEngine(ch.alloc());
        }
        ClientConnectionTimingsBuilder timingsBuilder = ch.attr(HttpChannelPool.TIMINGS_BUILDER_KEY).get();
        final ClientSslHandler sslHandler = new ClientSslHandler(sslEngine, timingsBuilder);
        p.addLast(HttpClientPipelineConfigurator.configureSslHandler(sslHandler));
        p.addLast(TrafficLoggingHandler.CLIENT);
        p.addLast(new ChannelInboundHandlerAdapter(){
            @Nullable
            private Boolean handshakeFailed;

            @Override
            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                SessionProtocol protocol;
                if (!(evt instanceof SslHandshakeCompletionEvent)) {
                    ctx.fireUserEventTriggered(evt);
                    return;
                }
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                this.handshakeFailed = !handshakeEvent.isSuccess();
                if (this.handshakeFailed.booleanValue()) {
                    return;
                }
                if (!sslHandler.handshakeFuture().isDone()) {
                    return;
                }
                if (HttpClientPipelineConfigurator.isHttp2Protocol(sslHandler)) {
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP1_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H1, SessionProtocol.H2, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.addBeforeSessionHandler(p, HttpClientPipelineConfigurator.this.newHttp2ConnectionHandler(ch, SessionProtocol.H2));
                    protocol = SessionProtocol.H2;
                } else {
                    if (HttpClientPipelineConfigurator.this.clientFactory.useHttp2WithoutAlpn() && HttpClientPipelineConfigurator.this.attemptUpgrade()) {
                        HttpClientPipelineConfigurator.this.configureUpgradeCodec(ch, h -> HttpClientPipelineConfigurator.addBeforeSessionHandler(p, h));
                        p.remove(this);
                        return;
                    }
                    if (HttpClientPipelineConfigurator.this.httpPreference != HttpPreference.HTTP1_REQUIRED) {
                        SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), SessionProtocol.H2);
                    }
                    if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                        HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, SessionProtocol.H2, SessionProtocol.H1, "unexpected protocol negotiation result");
                        return;
                    }
                    HttpClientPipelineConfigurator.addBeforeSessionHandler(p, HttpClientPipelineConfigurator.newHttp1Codec(HttpClientPipelineConfigurator.this.clientFactory.http1MaxInitialLineLength(), HttpClientPipelineConfigurator.this.clientFactory.http1MaxHeaderSize(), HttpClientPipelineConfigurator.this.clientFactory.http1MaxChunkSize()));
                    protocol = SessionProtocol.H1;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, protocol);
                p.remove(this);
            }

            @Override
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (this.handshakeFailed == null) {
                    String tlsVersion = sslHandler.engine().getSession().getProtocol();
                    PreTlsHandshakeException preTlsHandshakeException = new PreTlsHandshakeException("An unexpected exception before a TLS handshake starts. The possible reason could be one of: [connection forcefully closed by peer, unsupported TLS version, no cipher suites in common, etc.] (TLS version: " + tlsVersion + ", cipher suites: " + HttpClientPipelineConfigurator.this.sslCtx.cipherSuites() + ')', cause);
                    PendingExceptionUtil.setPendingException(ctx, (Throwable)preTlsHandshakeException);
                    return;
                }
                if (this.handshakeFailed.booleanValue() && cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
                    PendingExceptionUtil.setPendingException(ctx, cause.getCause());
                    return;
                }
                Exceptions.logIfUnexpected(logger, ctx.channel(), cause);
                ctx.close();
            }
        });
    }

    private SocketAddress remoteAddress(ChannelHandlerContext ctx) {
        return MoreObjects.firstNonNull(ctx.channel().remoteAddress(), this.remoteAddress);
    }

    private static SslHandler configureSslHandler(SslHandler sslHandler) {
        SSLEngine engine = sslHandler.engine();
        SSLParameters params = engine.getSSLParameters();
        params.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(params);
        return sslHandler;
    }

    private boolean attemptUpgrade() {
        switch (this.httpPreference.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                assert (this.remoteAddress != null);
                return !SessionProtocolNegotiationCache.isUnsupported(this.remoteAddress, SessionProtocol.H2C);
            }
            case 2: {
                return true;
            }
        }
        throw new Error();
    }

    private void configureUpgradeCodec(Channel ch, Consumer<ChannelHandler> pipelineCustomizer) {
        boolean shouldUsePreface;
        Http2ClientConnectionHandler http2Handler = this.newHttp2ConnectionHandler(ch, this.http2);
        boolean bl = shouldUsePreface = this.httpPreference == HttpPreference.HTTP2_REQUIRED || this.clientFactory.useHttp2Preface();
        if (shouldUsePreface) {
            pipelineCustomizer.accept(new DowngradeHandler());
            pipelineCustomizer.accept(http2Handler);
        } else {
            HttpClientCodec http1Codec = HttpClientPipelineConfigurator.newHttp1Codec(this.clientFactory.http1MaxInitialLineLength(), this.clientFactory.http1MaxHeaderSize(), this.clientFactory.http1MaxChunkSize());
            Http2ClientUpgradeCodec http2ClientUpgradeCodec = new Http2ClientUpgradeCodec(http2Handler);
            HttpClientUpgradeHandler http2UpgradeHandler = new HttpClientUpgradeHandler(http1Codec, http2ClientUpgradeCodec, (int)Math.min(Integer.MAX_VALUE, 16384L));
            pipelineCustomizer.accept(http1Codec);
            pipelineCustomizer.accept(new WorkaroundHandler());
            pipelineCustomizer.accept(http2UpgradeHandler);
            pipelineCustomizer.accept(new UpgradeRequestHandler(http2Handler.responseDecoder()));
        }
    }

    private void configureAsHttp(Channel ch, ChannelPromise connectionPromise) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(TrafficLoggingHandler.CLIENT);
        if (this.attemptUpgrade()) {
            this.configureUpgradeCodec(ch, xva$0 -> pipeline.addLast((ChannelHandler)xva$0));
        } else {
            pipeline.addLast(HttpClientPipelineConfigurator.newHttp1Codec(this.clientFactory.http1MaxInitialLineLength(), this.clientFactory.http1MaxHeaderSize(), this.clientFactory.http1MaxChunkSize()));
            connectionPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    this.finishSuccessfully(pipeline, SessionProtocol.H1C);
                }
            }));
        }
    }

    void finishSuccessfully(ChannelPipeline pipeline, SessionProtocol protocol) {
        int initialWindow;
        if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
            HttpClientPipelineConfigurator.addBeforeSessionHandler(pipeline, this.webSocket ? new WebSocketHttp1ClientChannelHandler(pipeline.channel()) : new Http1ResponseDecoder(pipeline.channel(), this.clientFactory, protocol));
        } else if ((protocol == SessionProtocol.H2 || protocol == SessionProtocol.H2C) && (initialWindow = this.clientFactory.http2InitialConnectionWindowSize()) > 65535) {
            HttpClientPipelineConfigurator.incrementLocalWindowSize(pipeline, initialWindow - 65535);
        }
        pipeline.fireUserEventTriggered((Object)protocol);
    }

    private static void incrementLocalWindowSize(ChannelPipeline pipeline, int delta) {
        try {
            Http2Connection connection = pipeline.get(Http2ClientConnectionHandler.class).connection();
            connection.local().flowController().incrementWindowSize(connection.connectionStream(), delta);
        }
        catch (Http2Exception e) {
            logger.warn("Failed to increment local flowController window size: {}", (Object)delta, (Object)e);
        }
    }

    private static void addBeforeSessionHandler(ChannelPipeline pipeline, ChannelHandler handler) {
        ChannelHandlerContext lastContext = pipeline.lastContext();
        if (lastContext.handler().getClass() == HttpSessionHandler.class) {
            pipeline.addBefore(lastContext.name(), null, handler);
        } else {
            pipeline.addLast(handler);
        }
    }

    void finishWithNegotiationFailure(ChannelHandlerContext ctx, SessionProtocol expected, SessionProtocol actual, String reason) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.channel().eventLoop().execute(() -> pipeline.fireUserEventTriggered(new SessionProtocolNegotiationException(expected, actual, reason)));
        ctx.close();
    }

    private boolean isHttps() {
        return this.sslCtx != null;
    }

    private static boolean isHttp2Protocol(SslHandler sslHandler) {
        return "h2".equals(sslHandler.applicationProtocol());
    }

    static void retryWith(ChannelHandlerContext ctx, SessionProtocol protocol) {
        HttpSession.get(ctx.channel()).retryWith(protocol);
        ctx.close();
    }

    private Http2ClientConnectionHandler newHttp2ConnectionHandler(Channel ch, SessionProtocol protocol) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        Http2ConnectionEncoder encoder = HttpClientPipelineConfigurator.encoder(connection);
        Http2ConnectionDecoder decoder = this.decoder(connection, encoder);
        Http2ClientConnectionHandlerBuilder builder = new Http2ClientConnectionHandlerBuilder(ch, this.clientFactory, protocol);
        return (Http2ClientConnectionHandler)((Http2ClientConnectionHandlerBuilder)((Http2ClientConnectionHandlerBuilder)builder.codec(decoder, encoder)).initialSettings(this.http2Settings())).build();
    }

    private static Http2ConnectionEncoder encoder(Http2Connection connection) {
        Http2FrameWriter writer = new DefaultHttp2FrameWriter();
        writer = new Http2OutboundFrameLogger(writer, frameLogger);
        return new DefaultHttp2ConnectionEncoder(connection, writer);
    }

    private Http2ConnectionDecoder decoder(Http2Connection connection, Http2ConnectionEncoder encoder) {
        ArmeriaHttp2HeadersDecoder headersDecoder = new ArmeriaHttp2HeadersDecoder(false, this.clientFactory.http2MaxHeaderListSize());
        Http2FrameReader reader = new DefaultHttp2FrameReader(headersDecoder);
        reader = new Http2InboundFrameLogger(reader, frameLogger);
        return new DefaultHttp2ConnectionDecoder(connection, encoder, reader);
    }

    private Http2Settings http2Settings() {
        int maxFrameSize;
        Http2Settings settings = new Http2Settings();
        int initialWindowSize = this.clientFactory.http2InitialStreamWindowSize();
        if (initialWindowSize != 65535) {
            settings.initialWindowSize(initialWindowSize);
        }
        if ((maxFrameSize = this.clientFactory.http2MaxFrameSize()) != 16384) {
            settings.maxFrameSize(maxFrameSize);
        }
        settings.maxHeaderListSize(this.clientFactory.http2MaxHeaderListSize());
        settings.pushEnabled(false);
        return settings;
    }

    private static HttpClientCodec newHttp1Codec(int defaultMaxInitialLineLength, int defaultMaxHeaderSize, int defaultMaxChunkSize) {
        return new HttpClientCodec(defaultMaxInitialLineLength, defaultMaxHeaderSize, defaultMaxChunkSize);
    }

    static {
        RequestTarget asterisk = RequestTarget.forClient("*");
        assert (asterisk != null);
        REQ_TARGET_ASTERISK = asterisk;
    }

    private static enum HttpPreference {
        HTTP1_REQUIRED,
        HTTP2_PREFERRED,
        HTTP2_REQUIRED;

    }

    private static final class ReadSuppressingAndChannelDeactivatingHandler
    extends ReadSuppressingHandler {
        private static final ReadSuppressingAndChannelDeactivatingHandler INSTANCE = new ReadSuppressingAndChannelDeactivatingHandler();

        private ReadSuppressingAndChannelDeactivatingHandler() {
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            HttpSession.get(ctx.channel()).markUnacquirable();
            super.close(ctx, promise);
        }
    }

    private static final class ClientSslHandler
    extends SslHandler {
        private final ClientConnectionTimingsBuilder timingsBuilder;

        ClientSslHandler(SSLEngine engine, ClientConnectionTimingsBuilder timingsBuilder) {
            super(engine);
            this.timingsBuilder = timingsBuilder;
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.timingsBuilder.tlsHandshakeStart();
            super.channelActive(ctx);
            this.handshakeFuture().addListener(future -> this.timingsBuilder.tlsHandshakeEnd());
        }
    }

    private final class DowngradeHandler
    extends ByteToMessageDecoder {
        private boolean handledResponse;

        private DowngradeHandler() {
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 9) {
                return;
            }
            this.handledResponse = true;
            ChannelPipeline p = ctx.pipeline();
            if (!this.isSettingsFrame(in)) {
                SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), HttpClientPipelineConfigurator.this.http2);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, "received a non-HTTP/2 response for the HTTP/2 connection preface");
                } else {
                    HttpClientPipelineConfigurator.retryWith(ctx, HttpClientPipelineConfigurator.this.http1);
                }
                in.skipBytes(in.readableBytes());
            } else {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, HttpClientPipelineConfigurator.this.http2);
            }
            p.remove(this);
        }

        private boolean isSettingsFrame(ByteBuf in) {
            int start = in.readerIndex();
            return in.getByte(start + 3) == 4 && (in.getInt(start + 5) & Integer.MAX_VALUE) == 0;
        }

        @Override
        protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            super.decodeLast(ctx, in, out);
            if (!this.handledResponse) {
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, "too little data to determine the HTTP version");
                } else {
                    HttpClientPipelineConfigurator.retryWith(ctx, HttpClientPipelineConfigurator.this.http1);
                }
            }
        }
    }

    private static final class WorkaroundHandler
    extends ChannelDuplexHandler {
        private static final AsciiString CONNECTION_VALUE = AsciiString.cached("HTTP2-Settings,Upgrade");
        private boolean needsToFilterUpgradeResponse = true;
        private boolean needsToFilterUpgradeRequest = true;

        private WorkaroundHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.needsToFilterUpgradeResponse && msg instanceof HttpResponse) {
                HttpHeaders headers;
                this.needsToFilterUpgradeResponse = false;
                HttpResponse res = (HttpResponse)msg;
                if (res.status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && !(headers = res.headers()).contains(HttpHeaderNames.UPGRADE)) {
                    headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                }
                if (!this.needsToFilterUpgradeRequest) {
                    ctx.pipeline().remove(this);
                }
            }
            ctx.fireChannelRead(msg);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (this.needsToFilterUpgradeRequest) {
                this.needsToFilterUpgradeRequest = false;
                FullHttpRequest req = (FullHttpRequest)msg;
                req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)CONNECTION_VALUE);
                if (!this.needsToFilterUpgradeResponse) {
                    ctx.pipeline().remove(this);
                }
            }
            super.write(ctx, msg, promise);
        }
    }

    private final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private final Http2ResponseDecoder responseDecoder;
        @Nullable
        private HttpClientUpgradeHandler.UpgradeEvent upgradeEvt;
        private String upgradeRejectionCause = "";
        private boolean needsToClose;

        UpgradeRequestHandler(Http2ResponseDecoder responseDecoder) {
            this.responseDecoder = responseDecoder;
        }

        @Override
        public void channelActive(final ChannelHandlerContext ctx) throws Exception {
            String host;
            DefaultFullHttpRequest upgradeReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
            assert (HttpClientPipelineConfigurator.this.remoteAddress != null);
            if (HttpClientPipelineConfigurator.this.remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress raddr = (InetSocketAddress)HttpClientPipelineConfigurator.this.remoteAddress;
                host = ArmeriaHttpUtil.authorityHeader(raddr.getHostString(), raddr.getPort(), (HttpClientPipelineConfigurator.this.isHttps() ? SessionProtocol.H1 : SessionProtocol.H1C).defaultPort());
            } else {
                assert (HttpClientPipelineConfigurator.this.remoteAddress instanceof DomainSocketAddress) : HttpClientPipelineConfigurator.access$1400(HttpClientPipelineConfigurator.this);
                host = SystemInfo.hostname();
            }
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            upgradeReq.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)UserAgentUtil.USER_AGENT);
            ctx.writeAndFlush(upgradeReq);
            Http2ResponseDecoder responseDecoder = this.responseDecoder;
            DecodedHttpResponse res = new DecodedHttpResponse(ctx.channel().eventLoop());
            res.init(responseDecoder.inboundTrafficController());
            res.subscribe(new Subscriber<HttpObject>(){
                private boolean notified;

                @Override
                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(HttpObject o) {
                    if (this.notified) {
                        return;
                    }
                    this.notified = true;
                    assert (UpgradeRequestHandler.this.upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL);
                    UpgradeRequestHandler.this.onUpgradeResponse(ctx, true);
                }

                @Override
                public void onError(Throwable t) {
                    ctx.fireExceptionCaught(t);
                }

                @Override
                public void onComplete() {
                }
            }, ctx.channel().eventLoop());
            responseDecoder.reserveUnfinishedResponse(Integer.MAX_VALUE);
            DefaultClientRequestContext reqCtx = new DefaultClientRequestContext(ctx.channel().eventLoop(), Flags.meterRegistry(), SessionProtocol.H1C, RequestId.random(), karate.com.linecorp.armeria.common.HttpMethod.OPTIONS, REQ_TARGET_ASTERISK, ClientOptions.of(), HttpRequest.of(karate.com.linecorp.armeria.common.HttpMethod.OPTIONS, "*"), null, REQUEST_OPTIONS_FOR_UPGRADE_REQUEST, CancellationScheduler.noop(), System.nanoTime(), SystemInfo.currentTimeMicros());
            responseDecoder.addResponse(null, 0, res, reqCtx, ctx.channel().eventLoop());
            ctx.fireChannelActive();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (!(evt instanceof HttpClientUpgradeHandler.UpgradeEvent)) {
                ctx.fireUserEventTriggered(evt);
                return;
            }
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = (HttpClientUpgradeHandler.UpgradeEvent)((Object)evt);
            if (upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
                return;
            }
            this.upgradeEvt = upgradeEvt;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HttpResponse) {
                assert (this.upgradeEvt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED);
                HttpResponse res = (HttpResponse)msg;
                this.upgradeRejectionCause = "Upgrade request rejected with: " + res;
                boolean bl = this.needsToClose = !HttpUtil.isKeepAlive(res) || !HttpUtil.isContentLengthSet(res) && !HttpUtil.isTransferEncodingChunked(res);
                if (this.needsToClose) {
                    this.onUpgradeResponse(ctx, false);
                }
                ReferenceCountUtil.release(msg);
                return;
            }
            if (this.needsToClose) {
                ReferenceCountUtil.release(msg);
                return;
            }
            if (msg instanceof HttpContent) {
                if (msg instanceof LastHttpContent) {
                    this.onUpgradeResponse(ctx, false);
                }
                ReferenceCountUtil.release(msg);
                return;
            }
            ctx.fireChannelRead(msg);
        }

        private void onUpgradeResponse(ChannelHandlerContext ctx, boolean success) {
            HttpClientUpgradeHandler.UpgradeEvent upgradeEvt = this.upgradeEvt;
            assert (upgradeEvt != null) : "received an upgrade response before an UpgradeEvent";
            ChannelPipeline p = ctx.pipeline();
            p.remove(this);
            if (this.needsToClose) {
                SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), HttpClientPipelineConfigurator.this.http2);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, this.upgradeRejectionCause);
                } else {
                    HttpClientPipelineConfigurator.retryWith(ctx, HttpClientPipelineConfigurator.this.http1);
                }
                return;
            }
            if (success) {
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, HttpClientPipelineConfigurator.this.http2);
            } else {
                SessionProtocolNegotiationCache.setUnsupported(HttpClientPipelineConfigurator.this.remoteAddress(ctx), HttpClientPipelineConfigurator.this.http2);
                if (HttpClientPipelineConfigurator.this.httpPreference == HttpPreference.HTTP2_REQUIRED) {
                    HttpClientPipelineConfigurator.this.finishWithNegotiationFailure(ctx, HttpClientPipelineConfigurator.this.http2, HttpClientPipelineConfigurator.this.http1, this.upgradeRejectionCause);
                    return;
                }
                HttpClientPipelineConfigurator.this.finishSuccessfully(p, HttpClientPipelineConfigurator.this.http1);
            }
        }
    }
}

