/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.util.Objects;
import karate.com.linecorp.armeria.client.InvalidResponseException;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@UnstableApi
public final class InvalidHttpResponseException
extends InvalidResponseException {
    private static final long serialVersionUID = 3883287492432644897L;
    private final AggregatedHttpResponse response;

    public InvalidHttpResponseException(AggregatedHttpResponse response) {
        this(response, null);
    }

    public InvalidHttpResponseException(AggregatedHttpResponse response, @Nullable Throwable cause) {
        super(Objects.requireNonNull(response, "response").toString(), cause);
        InvalidHttpResponseException.ensureNonPooledObject(response);
        this.response = response;
    }

    public InvalidHttpResponseException(AggregatedHttpResponse response, String message, @Nullable Throwable cause) {
        super(Objects.requireNonNull(message, "message"), cause);
        Objects.requireNonNull(response, "response");
        InvalidHttpResponseException.ensureNonPooledObject(response);
        this.response = response;
    }

    public AggregatedHttpResponse response() {
        return this.response;
    }

    private static void ensureNonPooledObject(AggregatedHttpResponse response) {
        Preconditions.checkArgument(!response.content().isPooled(), "Cannot create an %s with the pooled content: %s (expected: a non-pooled content)", (Object)InvalidHttpResponseException.class.getSimpleName(), (Object)response);
    }
}

