/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import karate.com.linecorp.armeria.client.DnsCache;
import karate.com.linecorp.armeria.client.RefreshingAddressResolver;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.SystemInfo;
import karate.com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import karate.com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import karate.com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.handler.codec.dns.DnsRecordType;
import karate.io.netty.resolver.AddressResolver;
import karate.io.netty.resolver.AddressResolverGroup;
import karate.io.netty.resolver.HostsFileEntriesResolver;
import karate.io.netty.resolver.ResolvedAddressTypes;
import karate.io.netty.resolver.dns.DnsNameResolverBuilder;
import karate.io.netty.util.NetUtil;
import karate.io.netty.util.concurrent.EventExecutor;

final class RefreshingAddressResolverGroup
extends AddressResolverGroup<InetSocketAddress> {
    private static final List<DnsRecordType> defaultDnsRecordTypes;
    private final int negativeTtl;
    private final List<DnsRecordType> dnsRecordTypes;
    private final DnsCache dnsResolverCache;
    private final boolean autoRefresh;
    @Nullable
    private final Backoff autoRefreshBackoff;
    @Nullable
    private final ToLongFunction<String> autoRefreshTimeoutFunction;
    private final List<String> searchDomains;
    private final int ndots;
    private final long queryTimeoutMillis;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final Cache<String, RefreshingAddressResolver.CacheEntry> addressResolverCache;
    private final Consumer<DnsNameResolverBuilder> resolverConfigurator;
    @Nullable
    private final ResolvedAddressTypes resolvedAddressTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static ImmutableList<DnsRecordType> dnsRecordTypes(ResolvedAddressTypes resolvedAddressTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                builder.add(DnsRecordType.A);
                break;
            }
            case IPV6_ONLY: {
                builder.add(DnsRecordType.AAAA);
                break;
            }
            case IPV4_PREFERRED: {
                builder.add(DnsRecordType.A);
                builder.add(DnsRecordType.AAAA);
                break;
            }
            case IPV6_PREFERRED: {
                builder.add(DnsRecordType.AAAA);
                builder.add(DnsRecordType.A);
            }
        }
        return builder.build();
    }

    RefreshingAddressResolverGroup(String cacheSpec, int negativeTtl, @Nullable ResolvedAddressTypes resolvedAddressTypes, DnsCache dnsResolverCache, boolean autoRefresh, @Nullable Backoff autoRefreshBackoff, @Nullable ToLongFunction<String> autoRefreshTimeoutFunction, List<String> searchDomains, int ndots, long queryTimeoutMillis, HostsFileEntriesResolver hostsFileEntriesResolver, Consumer<DnsNameResolverBuilder> resolverConfigurator) {
        this.negativeTtl = negativeTtl;
        this.dnsRecordTypes = resolvedAddressTypes == null ? defaultDnsRecordTypes : RefreshingAddressResolverGroup.dnsRecordTypes(resolvedAddressTypes);
        this.dnsResolverCache = dnsResolverCache;
        this.autoRefresh = autoRefresh;
        this.autoRefreshBackoff = autoRefreshBackoff;
        this.autoRefreshTimeoutFunction = autoRefreshTimeoutFunction;
        this.searchDomains = searchDomains;
        this.ndots = ndots;
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        this.addressResolverCache = RefreshingAddressResolverGroup.buildCache(cacheSpec);
        this.resolverConfigurator = resolverConfigurator;
        this.resolvedAddressTypes = resolvedAddressTypes;
    }

    Cache<String, RefreshingAddressResolver.CacheEntry> cache() {
        return this.addressResolverCache;
    }

    @Override
    protected AddressResolver<InetSocketAddress> newResolver(EventExecutor executor) throws Exception {
        if (!$assertionsDisabled && !(executor instanceof EventLoop)) {
            throw new AssertionError();
        }
        EventLoop eventLoop = (EventLoop)executor;
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(eventLoop);
        if (this.resolvedAddressTypes != null) {
            builder.resolvedAddressTypes(this.resolvedAddressTypes);
        }
        this.resolverConfigurator.accept(builder);
        DefaultDnsResolver resolver = DefaultDnsResolver.of(builder.build(), this.dnsResolverCache, executor, this.searchDomains, this.ndots, this.queryTimeoutMillis, this.hostsFileEntriesResolver);
        return new RefreshingAddressResolver(eventLoop, resolver, this.dnsRecordTypes, this.addressResolverCache, this.dnsResolverCache, this.negativeTtl, this.autoRefresh, this.autoRefreshBackoff, this.autoRefreshTimeoutFunction);
    }

    @Override
    public void close() {
        super.close();
        this.addressResolverCache.invalidateAll();
    }

    private static Cache<String, RefreshingAddressResolver.CacheEntry> buildCache(String cacheSpec) {
        Caffeine<Object, Object> b = Caffeine.from(cacheSpec);
        b.removalListener((key, value, cause) -> {
            if (value != null) {
                value.clear();
            }
        });
        return b.build();
    }

    static {
        boolean bl = $assertionsDisabled = !RefreshingAddressResolverGroup.class.desiredAssertionStatus();
        ResolvedAddressTypes resolvedAddressTypes = SystemInfo.hasIpV6() ? (NetUtil.isIpV6AddressesPreferred() ? ResolvedAddressTypes.IPV6_PREFERRED : ResolvedAddressTypes.IPV4_PREFERRED) : ResolvedAddressTypes.IPV4_ONLY;
        defaultDnsRecordTypes = RefreshingAddressResolverGroup.dnsRecordTypes(resolvedAddressTypes);
    }
}

