/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import karate.com.fasterxml.jackson.databind.ObjectMapper;
import karate.com.linecorp.armeria.client.FutureResponseAs;
import karate.com.linecorp.armeria.client.ResponseAs;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.internal.common.JacksonUtil;

final class ResponseAsUtil {
    static final ObjectMapper OBJECT_MAPPER = JacksonUtil.newDefaultObjectMapper();
    static final Predicate<AggregatedHttpResponse> SUCCESS_PREDICATE = res -> res.status().isSuccess();
    static final ResponseAs<HttpResponse, AggregatedHttpResponse> BLOCKING = new ResponseAs<HttpResponse, AggregatedHttpResponse>(){

        @Override
        public AggregatedHttpResponse as(HttpResponse response) {
            Objects.requireNonNull(response, "response");
            try {
                return response.aggregate().join();
            }
            catch (Exception ex) {
                return (AggregatedHttpResponse)Exceptions.throwUnsafely(Exceptions.peel(ex));
            }
        }

        @Override
        public boolean requiresAggregation() {
            return true;
        }
    };

    static <T> FutureResponseAs<T> aggregateAndConvert(final ResponseAs<AggregatedHttpResponse, T> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        return new FutureResponseAs<T>(){

            @Override
            public CompletableFuture<T> as(HttpResponse response) {
                Objects.requireNonNull(response, "response");
                return response.aggregate().thenApply(responseAs::as);
            }

            @Override
            public boolean requiresAggregation() {
                return true;
            }
        };
    }

    private ResponseAsUtil() {
    }
}

