/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.util.DomainSocketAddress;
import karate.com.linecorp.armeria.common.util.LruMap;
import karate.com.linecorp.armeria.internal.common.util.DomainSocketUtil;
import karate.com.linecorp.armeria.internal.common.util.IpAddrUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionProtocolNegotiationCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionProtocolNegotiationCache.class);
    private static final StampedLock lock = new StampedLock();
    private static final Map<String, CacheEntry> cache = new LruMap<String, CacheEntry>(65536){
        private static final long serialVersionUID = -2506868886873712772L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
            boolean remove = super.removeEldestEntry(eldest);
            if (remove) {
                logger.debug("Evicted: '{}' does not support {}", (Object)eldest.getKey(), (Object)eldest.getValue());
            }
            return remove;
        }
    };

    public static boolean isUnsupported(Endpoint endpoint, SessionProtocol protocol) {
        Objects.requireNonNull(endpoint, "endpoint");
        Objects.requireNonNull(protocol, "protocol");
        return SessionProtocolNegotiationCache.isUnsupported(SessionProtocolNegotiationCache.key(endpoint, protocol), protocol);
    }

    public static boolean isUnsupported(SocketAddress remoteAddress, SessionProtocol protocol) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        Objects.requireNonNull(protocol, "protocol");
        return SessionProtocolNegotiationCache.isUnsupported(SessionProtocolNegotiationCache.key(remoteAddress), protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUnsupported(String key, SessionProtocol protocol) {
        CacheEntry e;
        long stamp = lock.readLock();
        try {
            e = cache.get(key);
        }
        finally {
            lock.unlockRead(stamp);
        }
        if (e == null) {
            return false;
        }
        return e.isUnsupported(protocol);
    }

    public static void setUnsupported(SocketAddress remoteAddress, SessionProtocol protocol) {
        Objects.requireNonNull(protocol, "protocol");
        String key = SessionProtocolNegotiationCache.key(remoteAddress);
        CacheEntry e = SessionProtocolNegotiationCache.getOrCreate(key);
        if (e.addUnsupported(protocol)) {
            logger.debug("Updated: '{}' does not support {}", (Object)key, (Object)e);
        }
    }

    public static void clear() {
        int size;
        long stamp = lock.readLock();
        try {
            size = cache.size();
            if (size == 0) {
                return;
            }
            stamp = SessionProtocolNegotiationCache.convertToWriteLock(stamp);
            size = cache.size();
            cache.clear();
        }
        finally {
            lock.unlock(stamp);
        }
        if (size != 0 && logger.isDebugEnabled()) {
            if (size != 1) {
                logger.debug("Cleared: {} entries", (Object)size);
            } else {
                logger.debug("Cleared: 1 entry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheEntry getOrCreate(String key) {
        long stamp = lock.readLock();
        try {
            CacheEntry entry = cache.get(key);
            if (entry != null) {
                CacheEntry cacheEntry = entry;
                return cacheEntry;
            }
            stamp = SessionProtocolNegotiationCache.convertToWriteLock(stamp);
            CacheEntry cacheEntry = cache.computeIfAbsent(key, CacheEntry::new);
            return cacheEntry;
        }
        finally {
            lock.unlock(stamp);
        }
    }

    static String key(Endpoint endpoint, SessionProtocol protocol) {
        if (endpoint.isDomainSocket()) {
            return endpoint.host();
        }
        return endpoint.host() + '|' + endpoint.port(protocol.defaultPort());
    }

    static String key(SocketAddress remoteAddress) {
        if (remoteAddress instanceof DomainSocketAddress) {
            return ((DomainSocketAddress)remoteAddress).authority();
        }
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress raddr = (InetSocketAddress)remoteAddress;
            String hostOrIpAddr = raddr.getHostString();
            String normalizedIpAddr = IpAddrUtil.normalize(hostOrIpAddr);
            if (normalizedIpAddr != null) {
                return normalizedIpAddr + '|' + raddr.getPort();
            }
            return hostOrIpAddr + '|' + raddr.getPort();
        }
        if (remoteAddress instanceof karate.io.netty.channel.unix.DomainSocketAddress) {
            return DomainSocketUtil.toAuthority(((karate.io.netty.channel.unix.DomainSocketAddress)remoteAddress).path());
        }
        throw new IllegalArgumentException("unsupported address type: " + remoteAddress.getClass().getName() + " (expected: InetSocketAddress or DomainSocketAddress)");
    }

    private static long convertToWriteLock(long stamp) {
        long writeStamp = lock.tryConvertToWriteLock(stamp);
        if (writeStamp == 0L) {
            lock.unlockRead(stamp);
            stamp = lock.writeLock();
        } else {
            stamp = writeStamp;
        }
        return stamp;
    }

    private SessionProtocolNegotiationCache() {
    }

    private static final class CacheEntry {
        private volatile Set<SessionProtocol> unsupported = ImmutableSet.of();

        CacheEntry(String key) {
        }

        boolean addUnsupported(SessionProtocol protocol) {
            Set<SessionProtocol> unsupported = this.unsupported;
            if (unsupported.contains((Object)protocol)) {
                return false;
            }
            this.unsupported = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(unsupported)).add((Object)protocol)).build();
            return true;
        }

        boolean isUnsupported(SessionProtocol protocol) {
            Objects.requireNonNull(protocol, "protocol");
            return this.unsupported.contains((Object)protocol);
        }

        public String toString() {
            return this.unsupported.toString();
        }
    }
}

