/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import karate.com.linecorp.armeria.client.BlockingWebClientRequestPreparation;
import karate.com.linecorp.armeria.client.RequestOptions;
import karate.com.linecorp.armeria.client.ResponseAs;
import karate.com.linecorp.armeria.client.ResponseTimeoutMode;
import karate.com.linecorp.armeria.client.WebClientRequestPreparation;
import karate.com.linecorp.armeria.client.WebRequestPreparationSetters;
import karate.com.linecorp.armeria.common.Cookie;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.io.netty.util.AttributeKey;
import karate.org.reactivestreams.Publisher;

@UnstableApi
public class TransformingRequestPreparation<T, R>
implements WebRequestPreparationSetters<R> {
    private final WebRequestPreparationSetters<T> delegate;
    private ResponseAs<T, R> responseAs;

    TransformingRequestPreparation(WebRequestPreparationSetters<T> delegate, ResponseAs<T, R> responseAs) {
        this.delegate = delegate;
        this.responseAs = responseAs;
    }

    @Override
    public R execute() {
        this.maybeSetDefaultExchangeType();
        return this.responseAs.as(this.delegate.execute());
    }

    private void maybeSetDefaultExchangeType() {
        if (this.delegate instanceof BlockingWebClientRequestPreparation) {
            return;
        }
        WebClientRequestPreparation webClientPreparation = (WebClientRequestPreparation)this.delegate;
        if (webClientPreparation.exchangeType() == null) {
            boolean requestStreaming = webClientPreparation.isRequestStreaming();
            boolean responseStreaming = !this.responseAs.requiresAggregation();
            this.exchangeType(ExchangeType.of(requestStreaming, responseStreaming));
        }
    }

    @Override
    public TransformingRequestPreparation<T, R> exchangeType(ExchangeType exchangeType) {
        this.delegate.exchangeType(exchangeType);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> responseTimeoutMode(ResponseTimeoutMode responseTimeoutMode) {
        this.delegate.responseTimeoutMode(responseTimeoutMode);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> requestOptions(RequestOptions requestOptions) {
        this.delegate.requestOptions(requestOptions);
        return this;
    }

    @UnstableApi
    public <U> TransformingRequestPreparation<T, U> as(ResponseAs<R, U> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        this.responseAs = this.responseAs.andThen(responseAs);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> get(String path) {
        this.delegate.get(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> post(String path) {
        this.delegate.post(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> put(String path) {
        this.delegate.put(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> delete(String path) {
        this.delegate.delete(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> patch(String path) {
        this.delegate.patch(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> options(String path) {
        this.delegate.options(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> head(String path) {
        this.delegate.head(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> trace(String path) {
        this.delegate.trace(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> method(HttpMethod method) {
        this.delegate.method(method);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> path(String path) {
        this.delegate.path(path);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> content(String content) {
        this.delegate.content(content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> content(MediaType contentType, CharSequence content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> content(MediaType contentType, String content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    @FormatMethod
    public TransformingRequestPreparation<T, R> content(String format, Object ... content) {
        this.delegate.content(format, content);
        return this;
    }

    @Override
    @FormatMethod
    public TransformingRequestPreparation<T, R> content(MediaType contentType, @FormatString String format, Object ... content) {
        this.delegate.content(contentType, format, content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> content(MediaType contentType, byte[] content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> content(MediaType contentType, HttpData content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> content(Publisher<? extends HttpData> content) {
        this.delegate.content(content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> content(MediaType contentType, Publisher<? extends HttpData> content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> contentJson(Object content) {
        this.delegate.contentJson(content);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> header(CharSequence name, Object value) {
        this.delegate.header(name, value);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        this.delegate.headers(headers);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> trailer(CharSequence name, Object value) {
        this.delegate.trailer(name, value);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        this.delegate.trailers(trailers);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> pathParam(String name, Object value) {
        this.delegate.pathParam(name, value);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> pathParams(Map<String, ?> pathParams) {
        this.delegate.pathParams(pathParams);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> disablePathParams() {
        this.delegate.disablePathParams();
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> queryParam(String name, Object value) {
        this.delegate.queryParam(name, value);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> queryParams(Iterable<? extends Map.Entry<? extends String, String>> queryParams) {
        this.delegate.queryParams(queryParams);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> cookie(Cookie cookie) {
        this.delegate.cookie(cookie);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> cookies(Iterable<? extends Cookie> cookies) {
        this.delegate.cookies(cookies);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> responseTimeout(Duration responseTimeout) {
        this.delegate.responseTimeout(responseTimeout);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> responseTimeoutMillis(long responseTimeoutMillis) {
        this.delegate.responseTimeoutMillis(responseTimeoutMillis);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> writeTimeout(Duration writeTimeout) {
        this.delegate.writeTimeout(writeTimeout);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> writeTimeoutMillis(long writeTimeoutMillis) {
        this.delegate.writeTimeoutMillis(writeTimeoutMillis);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> maxResponseLength(long maxResponseLength) {
        this.delegate.maxResponseLength(maxResponseLength);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> requestAutoAbortDelay(Duration delay) {
        this.delegate.requestAutoAbortDelay(delay);
        return this;
    }

    @Override
    public TransformingRequestPreparation<T, R> requestAutoAbortDelayMillis(long delayMillis) {
        this.delegate.requestAutoAbortDelayMillis(delayMillis);
        return this;
    }

    @Override
    public <V> TransformingRequestPreparation<T, R> attr(AttributeKey<V> key, @Nullable V value) {
        this.delegate.attr(key, value);
        return this;
    }
}

