/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.circuitbreaker;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreaker;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreakerConfig;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreakerListener;
import karate.com.linecorp.armeria.client.circuitbreaker.NonBlockingCircuitBreaker;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Ticker;

public final class CircuitBreakerBuilder {
    private static final double DEFAULT_FAILURE_RATE_THRESHOLD = 0.5;
    private static final long DEFAULT_MINIMUM_REQUEST_THRESHOLD = 10L;
    private static final int DEFAULT_TRIAL_REQUEST_INTERVAL_SECONDS = 3;
    private static final int DEFAULT_CIRCUIT_OPEN_WINDOW_SECONDS = 10;
    private static final int DEFAULT_COUNTER_SLIDING_WINDOW_SECONDS = 20;
    private static final int DEFAULT_COUNTER_UPDATE_INTERVAL_SECONDS = 1;
    private static final Ticker DEFAULT_TICKER = Ticker.systemTicker();
    @Nullable
    private final String name;
    private double failureRateThreshold = 0.5;
    private long minimumRequestThreshold = 10L;
    private Duration trialRequestInterval = Duration.ofSeconds(3L);
    private Duration circuitOpenWindow = Duration.ofSeconds(10L);
    private Duration counterSlidingWindow = Duration.ofSeconds(20L);
    private Duration counterUpdateInterval = Duration.ofSeconds(1L);
    private Ticker ticker = DEFAULT_TICKER;
    private List<CircuitBreakerListener> listeners = Collections.emptyList();

    CircuitBreakerBuilder(String name) {
        Objects.requireNonNull(name, "name");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name: <empty> (expected: a non-empty string)");
        }
        this.name = name;
    }

    CircuitBreakerBuilder() {
        this.name = null;
    }

    public CircuitBreakerBuilder failureRateThreshold(double failureRateThreshold) {
        if (failureRateThreshold <= 0.0 || 1.0 < failureRateThreshold) {
            throw new IllegalArgumentException("failureRateThreshold: " + failureRateThreshold + " (expected: > 0 and <= 1)");
        }
        this.failureRateThreshold = failureRateThreshold;
        return this;
    }

    public CircuitBreakerBuilder minimumRequestThreshold(long minimumRequestThreshold) {
        if (minimumRequestThreshold < 0L) {
            throw new IllegalArgumentException("minimumRequestThreshold: " + minimumRequestThreshold + " (expected: >= 0)");
        }
        this.minimumRequestThreshold = minimumRequestThreshold;
        return this;
    }

    public CircuitBreakerBuilder trialRequestInterval(Duration trialRequestInterval) {
        Objects.requireNonNull(trialRequestInterval, "trialRequestInterval");
        if (trialRequestInterval.isNegative() || trialRequestInterval.isZero()) {
            throw new IllegalArgumentException("trialRequestInterval: " + trialRequestInterval + " (expected: > 0)");
        }
        this.trialRequestInterval = trialRequestInterval;
        return this;
    }

    public CircuitBreakerBuilder trialRequestIntervalMillis(long trialRequestIntervalMillis) {
        this.trialRequestInterval(Duration.ofMillis(trialRequestIntervalMillis));
        return this;
    }

    public CircuitBreakerBuilder circuitOpenWindow(Duration circuitOpenWindow) {
        Objects.requireNonNull(circuitOpenWindow, "circuitOpenWindow");
        if (circuitOpenWindow.isNegative() || circuitOpenWindow.isZero()) {
            throw new IllegalArgumentException("circuitOpenWindow: " + circuitOpenWindow + " (expected: > 0)");
        }
        this.circuitOpenWindow = circuitOpenWindow;
        return this;
    }

    public CircuitBreakerBuilder circuitOpenWindowMillis(long circuitOpenWindowMillis) {
        this.circuitOpenWindow(Duration.ofMillis(circuitOpenWindowMillis));
        return this;
    }

    public CircuitBreakerBuilder counterSlidingWindow(Duration counterSlidingWindow) {
        Objects.requireNonNull(counterSlidingWindow, "counterSlidingWindow");
        if (counterSlidingWindow.isNegative() || counterSlidingWindow.isZero()) {
            throw new IllegalArgumentException("counterSlidingWindow: " + counterSlidingWindow + " (expected: > 0)");
        }
        this.counterSlidingWindow = counterSlidingWindow;
        return this;
    }

    public CircuitBreakerBuilder counterSlidingWindowMillis(long counterSlidingWindowMillis) {
        this.counterSlidingWindow(Duration.ofMillis(counterSlidingWindowMillis));
        return this;
    }

    public CircuitBreakerBuilder counterUpdateInterval(Duration counterUpdateInterval) {
        Objects.requireNonNull(counterUpdateInterval, "counterUpdateInterval");
        if (counterUpdateInterval.isNegative() || counterUpdateInterval.isZero()) {
            throw new IllegalArgumentException("counterUpdateInterval: " + counterUpdateInterval + " (expected: > 0)");
        }
        this.counterUpdateInterval = counterUpdateInterval;
        return this;
    }

    public CircuitBreakerBuilder counterUpdateIntervalMillis(long counterUpdateIntervalMillis) {
        this.counterUpdateInterval(Duration.ofMillis(counterUpdateIntervalMillis));
        return this;
    }

    public CircuitBreakerBuilder listener(CircuitBreakerListener listener) {
        Objects.requireNonNull(listener, "listener");
        if (this.listeners.isEmpty()) {
            this.listeners = new ArrayList<CircuitBreakerListener>(3);
        }
        this.listeners.add(listener);
        return this;
    }

    CircuitBreakerBuilder ticker(Ticker ticker) {
        this.ticker = Objects.requireNonNull(ticker, "ticker");
        return this;
    }

    public CircuitBreaker build() {
        if (this.counterSlidingWindow.compareTo(this.counterUpdateInterval) <= 0) {
            throw new IllegalStateException("counterSlidingWindow: " + this.counterSlidingWindow + " (expected: > counterUpdateInterval)");
        }
        return new NonBlockingCircuitBreaker(this.ticker, new CircuitBreakerConfig(this.name, this.failureRateThreshold, this.minimumRequestThreshold, this.circuitOpenWindow, this.trialRequestInterval, this.counterSlidingWindow, this.counterUpdateInterval, Collections.unmodifiableList(this.listeners)));
    }
}

