/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.circuitbreaker;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreakerDecision;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRule;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpResponseDuplicator;
import karate.com.linecorp.armeria.common.Response;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;

final class CircuitBreakerRuleUtil {
    static final CompletableFuture<CircuitBreakerDecision> SUCCESS_DECISION = UnmodifiableFuture.completedFuture(CircuitBreakerDecision.success());
    static final CompletableFuture<CircuitBreakerDecision> FAILURE_DECISION = UnmodifiableFuture.completedFuture(CircuitBreakerDecision.failure());
    static final CompletableFuture<CircuitBreakerDecision> IGNORE_DECISION = UnmodifiableFuture.completedFuture(CircuitBreakerDecision.ignore());
    static final CompletableFuture<CircuitBreakerDecision> NEXT_DECISION = UnmodifiableFuture.completedFuture(CircuitBreakerDecision.next());

    static <T extends Response> CircuitBreakerRuleWithContent<T> fromCircuitBreakerRule(final CircuitBreakerRule circuitBreakerRule) {
        return new CircuitBreakerRuleWithContent<T>(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                return circuitBreakerRule.shouldReportAsSuccess(ctx, cause);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return circuitBreakerRule.requiresResponseTrailers();
            }
        };
    }

    static <T extends Response> CircuitBreakerRule fromCircuitBreakerRuleWithContent(final CircuitBreakerRuleWithContent<T> circuitBreakerRuleWithContent) {
        return new CircuitBreakerRule(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable Throwable cause) {
                return circuitBreakerRuleWithContent.shouldReportAsSuccess(ctx, null, cause);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return circuitBreakerRuleWithContent.requiresResponseTrailers();
            }
        };
    }

    static CircuitBreakerRule orElse(final CircuitBreakerRule first, final CircuitBreakerRule second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new CircuitBreakerRule(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable Throwable cause) {
                CompletionStage<CircuitBreakerDecision> decisionFuture = first.shouldReportAsSuccess(ctx, cause);
                if (decisionFuture == SUCCESS_DECISION || decisionFuture == FAILURE_DECISION || decisionFuture == IGNORE_DECISION) {
                    return decisionFuture;
                }
                if (decisionFuture == NEXT_DECISION) {
                    return second.shouldReportAsSuccess(ctx, cause);
                }
                return decisionFuture.thenCompose(decision -> {
                    if (decision != CircuitBreakerDecision.next()) {
                        return decisionFuture;
                    }
                    return second.shouldReportAsSuccess(ctx, cause);
                });
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    static <T extends Response> CircuitBreakerRuleWithContent<T> orElse(final CircuitBreakerRule first, final CircuitBreakerRuleWithContent<T> second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new CircuitBreakerRuleWithContent<T>(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                if (response instanceof HttpResponse) {
                    try (HttpResponseDuplicator duplicator = ((HttpResponse)response).toDuplicator();){
                        CircuitBreakerRuleWithContent duplicatedSecond = CircuitBreakerRuleUtil.withDuplicator(second, duplicator);
                        CompletionStage completionStage = CircuitBreakerRuleUtil.handle(ctx, response, cause, CircuitBreakerRuleUtil.fromCircuitBreakerRule(first), duplicatedSecond);
                        return completionStage;
                    }
                }
                return CircuitBreakerRuleUtil.handle(ctx, response, cause, CircuitBreakerRuleUtil.fromCircuitBreakerRule(first), second);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    static <T extends Response> CircuitBreakerRuleWithContent<T> orElse(final CircuitBreakerRuleWithContent<T> first, final CircuitBreakerRule second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new CircuitBreakerRuleWithContent<T>(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                if (response instanceof HttpResponse) {
                    try (HttpResponseDuplicator duplicator = ((HttpResponse)response).toDuplicator();){
                        CircuitBreakerRuleWithContent duplicatedFirst = CircuitBreakerRuleUtil.withDuplicator(first, duplicator);
                        CompletionStage completionStage = CircuitBreakerRuleUtil.handle(ctx, response, cause, duplicatedFirst, CircuitBreakerRuleUtil.fromCircuitBreakerRule(second));
                        return completionStage;
                    }
                }
                return CircuitBreakerRuleUtil.handle(ctx, response, cause, first, CircuitBreakerRuleUtil.fromCircuitBreakerRule(second));
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    static <T extends Response> CircuitBreakerRuleWithContent<T> orElse(final CircuitBreakerRuleWithContent<T> first, final CircuitBreakerRuleWithContent<T> second) {
        final boolean requiresResponseTrailers = first.requiresResponseTrailers() || second.requiresResponseTrailers();
        return new CircuitBreakerRuleWithContent<T>(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause) {
                if (response instanceof HttpResponse) {
                    try (HttpResponseDuplicator duplicator = ((HttpResponse)response).toDuplicator();){
                        CircuitBreakerRuleWithContent duplicatedFirst = CircuitBreakerRuleUtil.withDuplicator(first, duplicator);
                        CircuitBreakerRuleWithContent duplicatedSecond = CircuitBreakerRuleUtil.withDuplicator(second, duplicator);
                        CompletionStage completionStage = CircuitBreakerRuleUtil.handle(ctx, response, cause, duplicatedFirst, duplicatedSecond);
                        return completionStage;
                    }
                }
                return CircuitBreakerRuleUtil.handle(ctx, response, cause, first, second);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    private static <T extends Response> CompletionStage<CircuitBreakerDecision> handle(ClientRequestContext ctx, @Nullable T response, @Nullable Throwable cause, CircuitBreakerRuleWithContent<T> first, CircuitBreakerRuleWithContent<T> second) {
        CompletionStage<CircuitBreakerDecision> decisionFuture = first.shouldReportAsSuccess(ctx, response, cause);
        if (decisionFuture == SUCCESS_DECISION || decisionFuture == FAILURE_DECISION || decisionFuture == IGNORE_DECISION) {
            return decisionFuture;
        }
        if (decisionFuture == NEXT_DECISION) {
            return second.shouldReportAsSuccess(ctx, response, cause);
        }
        return decisionFuture.thenCompose(decision -> {
            if (decision != CircuitBreakerDecision.next()) {
                return decisionFuture;
            }
            return second.shouldReportAsSuccess(ctx, response, cause);
        });
    }

    private static CircuitBreakerRuleWithContent<HttpResponse> withDuplicator(final CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent, final HttpResponseDuplicator duplicator) {
        return new CircuitBreakerRuleWithContent<HttpResponse>(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable HttpResponse response, @Nullable Throwable cause) {
                return ruleWithContent.shouldReportAsSuccess(ctx, duplicator.duplicate(), cause);
            }

            @Override
            public boolean requiresResponseTrailers() {
                return ruleWithContent.requiresResponseTrailers();
            }
        };
    }

    private CircuitBreakerRuleUtil() {
    }
}

