/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.circuitbreaker;

import java.util.Objects;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreakerListener;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMetrics;
import karate.com.linecorp.armeria.client.circuitbreaker.CircuitState;
import karate.com.linecorp.armeria.client.circuitbreaker.EventCount;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.common.metric.MicrometerUtil;
import karate.io.micrometer.core.instrument.MeterRegistry;

final class MetricCollectingCircuitBreakerListener
implements CircuitBreakerListener {
    private final MeterRegistry registry;
    private final String name;

    MetricCollectingCircuitBreakerListener(MeterRegistry registry, String name) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public void onStateChanged(String circuitBreakerName, CircuitState state) {
        this.metricsOf(circuitBreakerName).onStateChanged(state);
    }

    @Override
    @Deprecated
    public void onEventCountUpdated(String circuitBreakerName, EventCount eventCount) {
    }

    @Override
    public void onEventCountUpdated(String circuitBreakerName, karate.com.linecorp.armeria.common.util.EventCount eventCount) throws Exception {
        this.metricsOf(circuitBreakerName).onCountUpdated(eventCount);
    }

    @Override
    public void onRequestRejected(String circuitBreakerName) {
        this.metricsOf(circuitBreakerName).onRequestRejected();
    }

    private CircuitBreakerMetrics metricsOf(String circuitBreakerName) {
        MeterIdPrefix idPrefix = new MeterIdPrefix(this.name, "name", circuitBreakerName);
        return MicrometerUtil.register(this.registry, idPrefix, CircuitBreakerMetrics.class, CircuitBreakerMetrics::new);
    }
}

