/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.encoding;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.client.Client;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import karate.com.linecorp.armeria.client.encoding.DecodingClientBuilder;
import karate.com.linecorp.armeria.client.encoding.StreamDecoderFactory;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.RequestHeadersBuilder;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.encoding.DefaultHttpDecodedResponse;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Strings;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Streams;

public final class DecodingClient
extends SimpleDecoratingHttpClient {
    private static final Splitter ENCODING_SPLITTER = Splitter.on(',').trimResults();
    private final Map<String, StreamDecoderFactory> decoderFactories;
    private final String acceptEncodingHeader;
    private final boolean autoFillAcceptEncoding;
    private final boolean strictContentEncoding;

    public static Function<? super HttpClient, DecodingClient> newDecorator() {
        return DecodingClient.builder().newDecorator();
    }

    public static Function<? super HttpClient, DecodingClient> newDecorator(StreamDecoderFactory ... decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        return DecodingClient.newDecorator(ImmutableList.copyOf(decoderFactories));
    }

    public static Function<? super HttpClient, DecodingClient> newDecorator(Iterable<? extends StreamDecoderFactory> decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        ImmutableList<? extends StreamDecoderFactory> immutableDecoderFactories = ImmutableList.copyOf(decoderFactories);
        return client -> new DecodingClient((HttpClient)client, (Iterable<? extends StreamDecoderFactory>)immutableDecoderFactories, true, false);
    }

    public static DecodingClientBuilder builder() {
        return new DecodingClientBuilder();
    }

    DecodingClient(HttpClient delegate, Iterable<? extends StreamDecoderFactory> decoderFactories, boolean autoFillAcceptEncoding, boolean strictContentEncoding) {
        super(delegate);
        this.decoderFactories = Streams.stream(decoderFactories).collect(ImmutableMap.toImmutableMap(StreamDecoderFactory::encodingHeaderValue, Function.identity()));
        this.acceptEncodingHeader = String.join((CharSequence)",", this.decoderFactories.keySet());
        this.autoFillAcceptEncoding = autoFillAcceptEncoding;
        this.strictContentEncoding = strictContentEncoding;
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        Map<String, StreamDecoderFactory> decoderFactories = this.decoderFactories;
        if (this.autoFillAcceptEncoding) {
            if (req.headers().contains(HttpHeaderNames.ACCEPT_ENCODING)) {
                return (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
            }
            req = DecodingClient.updateAcceptEncoding(ctx, req, this.acceptEncodingHeader);
            return this.executeAndDecodeResponse(ctx, req, decoderFactories);
        }
        String acceptEncoding = req.headers().get(HttpHeaderNames.ACCEPT_ENCODING);
        if (Strings.isNullOrEmpty(acceptEncoding)) {
            return (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
        }
        ImmutableSet<String> encodings = ImmutableSet.copyOf(ENCODING_SPLITTER.split(acceptEncoding));
        ImmutableMap.Builder<String, StreamDecoderFactory> factoryBuilder = ImmutableMap.builderWithExpectedSize(encodings.size());
        for (String encoding : encodings) {
            StreamDecoderFactory factory = decoderFactories.get(encoding);
            if (factory == null) continue;
            factoryBuilder.put(factory.encodingHeaderValue(), factory);
        }
        ImmutableMap<String, StreamDecoderFactory> availableFactories = factoryBuilder.build();
        if (availableFactories.isEmpty()) {
            req = DecodingClient.updateAcceptEncoding(ctx, req, null);
            return (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
        }
        if (encodings.size() != availableFactories.size()) {
            String acceptEncodingHeader = String.join((CharSequence)",", availableFactories.keySet());
            req = DecodingClient.updateAcceptEncoding(ctx, req, acceptEncodingHeader);
        }
        decoderFactories = availableFactories;
        return this.executeAndDecodeResponse(ctx, req, decoderFactories);
    }

    private DefaultHttpDecodedResponse executeAndDecodeResponse(ClientRequestContext ctx, HttpRequest req, Map<String, StreamDecoderFactory> decoderFactories) throws Exception {
        HttpResponse res = (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
        return new DefaultHttpDecodedResponse(res, decoderFactories, ctx, this.strictContentEncoding);
    }

    private static HttpRequest updateAcceptEncoding(ClientRequestContext ctx, HttpRequest req, @Nullable String acceptEncoding) {
        RequestHeadersBuilder headersBuilder = acceptEncoding == null ? req.headers().toBuilder().removeAndThen(HttpHeaderNames.ACCEPT_ENCODING) : req.headers().toBuilder().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, acceptEncoding);
        HttpRequest updated = req.withHeaders(headersBuilder);
        ctx.updateRequest(updated);
        return updated;
    }
}

