/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.encoding;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.encoding.DecodingClient;
import karate.com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;

public final class DecodingClientBuilder {
    private List<StreamDecoderFactory> decoderFactories = StreamDecoderFactory.all();
    private boolean autoFillAcceptEncoding = true;
    private boolean strictContentEncoding;

    DecodingClientBuilder() {
    }

    public DecodingClientBuilder decoderFactories(StreamDecoderFactory ... decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        return this.decoderFactories(ImmutableList.copyOf(decoderFactories));
    }

    public DecodingClientBuilder decoderFactories(Iterable<? extends StreamDecoderFactory> decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        this.decoderFactories = ImmutableList.copyOf(decoderFactories);
        return this;
    }

    public DecodingClientBuilder autoFillAcceptEncoding(boolean autoFillAcceptEncoding) {
        this.autoFillAcceptEncoding = autoFillAcceptEncoding;
        return this;
    }

    public DecodingClientBuilder strictContentEncoding(boolean strict) {
        this.strictContentEncoding = strict;
        return this;
    }

    public Function<? super HttpClient, DecodingClient> newDecorator() {
        return this::build;
    }

    public DecodingClient build(HttpClient delegate) {
        return new DecodingClient(delegate, this.decoderFactories, this.autoFillAcceptEncoding, this.strictContentEncoding);
    }
}

