/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import java.util.function.ToLongFunction;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelector;
import karate.com.linecorp.armeria.client.endpoint.RoundRobinStrategy;
import karate.com.linecorp.armeria.client.endpoint.StickyEndpointSelectionStrategy;
import karate.com.linecorp.armeria.client.endpoint.WeightRampingUpStrategy;
import karate.com.linecorp.armeria.client.endpoint.WeightRampingUpStrategyBuilder;
import karate.com.linecorp.armeria.client.endpoint.WeightedRoundRobinStrategy;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;

@FunctionalInterface
public interface EndpointSelectionStrategy {
    public static EndpointSelectionStrategy weightedRoundRobin() {
        return WeightedRoundRobinStrategy.INSTANCE;
    }

    public static EndpointSelectionStrategy roundRobin() {
        return RoundRobinStrategy.INSTANCE;
    }

    @UnstableApi
    public static EndpointSelectionStrategy rampingUp() {
        return WeightRampingUpStrategy.INSTANCE;
    }

    @UnstableApi
    public static WeightRampingUpStrategyBuilder builderForRampingUp() {
        return new WeightRampingUpStrategyBuilder();
    }

    public static EndpointSelectionStrategy sticky(ToLongFunction<? super ClientRequestContext> requestContextHasher) {
        return new StickyEndpointSelectionStrategy(requestContextHasher);
    }

    public EndpointSelector newSelector(EndpointGroup var1);
}

