/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import java.util.Objects;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroupException;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@UnstableApi
public final class EndpointSelectionTimeoutException
extends EndpointGroupException {
    private static final long serialVersionUID = -3079582212067997365L;
    private static final EndpointSelectionTimeoutException INSTANCE = new EndpointSelectionTimeoutException();

    public static EndpointSelectionTimeoutException get(EndpointGroup endpointGroup, long selectionTimeoutMillis) {
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        return Flags.verboseExceptionSampler().isSampled(EndpointSelectionTimeoutException.class) ? new EndpointSelectionTimeoutException(endpointGroup, selectionTimeoutMillis) : INSTANCE;
    }

    private EndpointSelectionTimeoutException() {
    }

    private EndpointSelectionTimeoutException(EndpointGroup endpointGroup, long selectionTimeoutMillis) {
        super("Failed to select within " + selectionTimeoutMillis + " ms an endpoint from: " + endpointGroup);
    }
}

