/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.WeightRampingUpStrategyBuilder;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.primitives.Ints;

@FunctionalInterface
public interface EndpointWeightTransition {
    public static EndpointWeightTransition linear() {
        return WeightRampingUpStrategyBuilder.DEFAULT_LINEAR_TRANSITION;
    }

    public static EndpointWeightTransition aggression(double aggression, double minWeightPercent) {
        Preconditions.checkArgument(aggression > 0.0, "aggression: %s (expected: > 0.0)", (Object)aggression);
        Preconditions.checkArgument(minWeightPercent >= 0.0 && minWeightPercent <= 1.0, "minWeightPercent: %s (expected: >= 0.0, <= 1.0)", (Object)minWeightPercent);
        int aggressionPercentage = Ints.saturatedCast(Math.round(aggression * 100.0));
        double invertedAggression = 100.0 / (double)aggressionPercentage;
        return (endpoint, currentStep, totalSteps) -> {
            int weight = endpoint.weight();
            int minWeight = Ints.saturatedCast(Math.round((double)weight * minWeightPercent));
            int computedWeight = aggressionPercentage == 100 ? EndpointWeightTransition.linear().compute(endpoint, currentStep, totalSteps) : (int)((double)weight * Math.pow(1.0 * (double)currentStep / (double)totalSteps, invertedAggression));
            return Math.max(computedWeight, minWeight);
        };
    }

    public int compute(Endpoint var1, int var2, int var3);
}

