/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import karate.com.linecorp.armeria.client.endpoint.FileWatcherRegistry;
import karate.com.linecorp.armeria.client.endpoint.PropertiesEndpointGroupBuilder;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;

public final class PropertiesEndpointGroup
extends DynamicEndpointGroup {
    private static FileWatcherRegistry registry = new FileWatcherRegistry();
    @Nullable
    private FileWatcherRegistry.FileWatchRegisterKey watchRegisterKey;

    static void resetRegistry() throws Exception {
        registry.close();
        registry = new FileWatcherRegistry();
    }

    public static PropertiesEndpointGroup of(ClassLoader classLoader, String resourceName, String endpointKeyPrefix) {
        return PropertiesEndpointGroup.builder(classLoader, resourceName, endpointKeyPrefix).build();
    }

    public static PropertiesEndpointGroup of(Properties properties, String endpointKeyPrefix) {
        return PropertiesEndpointGroup.builder(properties, endpointKeyPrefix).build();
    }

    public static PropertiesEndpointGroup of(Path path, String endpointKeyPrefix) {
        return PropertiesEndpointGroup.builder(path, endpointKeyPrefix).build();
    }

    public static PropertiesEndpointGroupBuilder builder(ClassLoader classLoader, String resourceName, String endpointKeyPrefix) {
        Objects.requireNonNull(classLoader, "classLoader");
        Objects.requireNonNull(resourceName, "resourceName");
        Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix");
        return new PropertiesEndpointGroupBuilder(classLoader, resourceName, endpointKeyPrefix);
    }

    public static PropertiesEndpointGroupBuilder builder(Properties properties, String endpointKeyPrefix) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix");
        return new PropertiesEndpointGroupBuilder(properties, endpointKeyPrefix);
    }

    public static PropertiesEndpointGroupBuilder builder(Path path, String endpointKeyPrefix) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix");
        return new PropertiesEndpointGroupBuilder(path, endpointKeyPrefix);
    }

    PropertiesEndpointGroup(EndpointSelectionStrategy selectionStrategy, List<Endpoint> endpoints) {
        super(selectionStrategy);
        this.setEndpoints(endpoints);
    }

    PropertiesEndpointGroup(EndpointSelectionStrategy selectionStrategy, Path path, String endpointKeyPrefix, int defaultPort) {
        super(selectionStrategy);
        this.setEndpoints(PropertiesEndpointGroup.loadEndpoints(path, Objects.requireNonNull(endpointKeyPrefix, "endpointKeyPrefix"), defaultPort));
        this.watchRegisterKey = registry.register(path, () -> this.setEndpoints(PropertiesEndpointGroup.loadEndpoints(path, endpointKeyPrefix, defaultPort)));
    }

    private static List<Endpoint> loadEndpoints(Path path, String endpointKeyPrefix, int defaultPort) {
        List<Endpoint> list;
        block8: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                Properties props = new Properties();
                props.load(in);
                list = PropertiesEndpointGroup.loadEndpoints(props, endpointKeyPrefix, defaultPort);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("failed to load: " + path, e);
                }
            }
            in.close();
        }
        return list;
    }

    private static List<Endpoint> loadEndpoints(Properties properties, String endpointKeyPrefix, int defaultPort) {
        if (!endpointKeyPrefix.endsWith(".")) {
            endpointKeyPrefix = endpointKeyPrefix + ".";
        }
        ArrayList<Endpoint> newEndpoints = new ArrayList<Endpoint>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (!key.startsWith(endpointKeyPrefix)) continue;
            Endpoint endpoint = Endpoint.parse(value);
            newEndpoints.add(defaultPort == 0 ? endpoint : endpoint.withDefaultPort(defaultPort));
        }
        return ImmutableList.copyOf(newEndpoints);
    }

    @Override
    protected void doCloseAsync(CompletableFuture<?> future) {
        if (this.watchRegisterKey != null) {
            registry.unregister(this.watchRegisterKey);
        }
        future.complete(null);
    }

    @Override
    public String toString() {
        return this.toString(buf -> buf.append(", watchRegisterKey=").append(this.watchRegisterKey));
    }
}

