/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

final class RestartableThread {
    private final ReentrantLock lock = new ReentrantShortLock();
    @Nullable
    private Thread thread;
    private final Supplier<Runnable> runnableSupplier;
    private final String name;

    RestartableThread(String name, Supplier<Runnable> runnableSupplier) {
        this.name = name;
        this.runnableSupplier = runnableSupplier;
    }

    void start() {
        this.lock();
        try {
            if (!this.isRunning()) {
                Preconditions.checkState(this.thread == null, "trying to start thread without cleanup");
                this.thread = new Thread(this.runnableSupplier.get(), this.name);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
        finally {
            this.unlock();
        }
    }

    void stop() {
        this.lock();
        try {
            if (this.isRunning()) {
                Preconditions.checkState(this.thread != null, "tried to stop null thread");
                boolean interrupted = false;
                this.thread.interrupt();
                while (this.thread.isAlive()) {
                    try {
                        this.thread.join(1000L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                this.thread = null;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }
}

