/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.AbstractEndpointSelector;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelector;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;

final class RoundRobinStrategy
implements EndpointSelectionStrategy {
    static final RoundRobinStrategy INSTANCE = new RoundRobinStrategy();

    private RoundRobinStrategy() {
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new RoundRobinSelector(endpointGroup);
    }

    static class RoundRobinSelector
    extends AbstractEndpointSelector {
        private final AtomicInteger sequence = new AtomicInteger();

        RoundRobinSelector(EndpointGroup endpointGroup) {
            super(endpointGroup);
            this.initialize();
        }

        @Override
        @Nullable
        public Endpoint selectNow(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.group().endpoints();
            if (endpoints.isEmpty()) {
                return null;
            }
            int currentSequence = this.sequence.getAndIncrement();
            return endpoints.get(Math.abs(currentSequence % endpoints.size()));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("endpoints", this.group().endpoints()).toString();
        }
    }
}

