/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import java.util.List;
import java.util.Objects;
import java.util.function.ToLongFunction;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.AbstractEndpointSelector;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelector;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.hash.Hashing;

final class StickyEndpointSelectionStrategy
implements EndpointSelectionStrategy {
    private final ToLongFunction<? super ClientRequestContext> requestContextHasher;

    StickyEndpointSelectionStrategy(ToLongFunction<? super ClientRequestContext> requestContextHasher) {
        this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new StickyEndpointSelector(endpointGroup, this.requestContextHasher);
    }

    private static final class StickyEndpointSelector
    extends AbstractEndpointSelector {
        private final ToLongFunction<? super ClientRequestContext> requestContextHasher;

        StickyEndpointSelector(EndpointGroup endpointGroup, ToLongFunction<? super ClientRequestContext> requestContextHasher) {
            super(endpointGroup);
            this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
            this.initialize();
        }

        @Override
        @Nullable
        public Endpoint selectNow(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.group().endpoints();
            if (endpoints.isEmpty()) {
                return null;
            }
            long key = this.requestContextHasher.applyAsLong(ctx);
            int nearest = Hashing.consistentHash(key, endpoints.size());
            return endpoints.get(nearest);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("endpoints", this.group().endpoints()).toString();
        }
    }
}

