/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.AbstractEndpointSelector;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelector;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.client.endpoint.EndpointToStringUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WeightedRoundRobinStrategy
implements EndpointSelectionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(WeightedRoundRobinStrategy.class);
    static final WeightedRoundRobinStrategy INSTANCE = new WeightedRoundRobinStrategy();

    private WeightedRoundRobinStrategy() {
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new WeightedRoundRobinSelector(endpointGroup);
    }

    private static final class WeightedRoundRobinSelector
    extends AbstractEndpointSelector {
        private final AtomicInteger sequence = new AtomicInteger();
        @Nullable
        private volatile EndpointsAndWeights endpointsAndWeights;

        WeightedRoundRobinSelector(EndpointGroup endpointGroup) {
            super(endpointGroup);
            this.initialize();
        }

        @Override
        protected void updateNewEndpoints(List<Endpoint> endpoints) {
            EndpointsAndWeights endpointsAndWeights;
            boolean found = false;
            for (Endpoint endpoint : endpoints) {
                if (endpoint.weight() <= 0) continue;
                found = true;
                break;
            }
            if (!found) {
                logger.warn("No valid endpoint with weight > 0. endpoints: {}", (Object)EndpointToStringUtil.toShortString(endpoints));
            }
            if ((endpointsAndWeights = this.endpointsAndWeights) == null || endpointsAndWeights.endpoints != endpoints) {
                this.endpointsAndWeights = new EndpointsAndWeights(endpoints);
            }
        }

        @Override
        @Nullable
        public Endpoint selectNow(ClientRequestContext ctx) {
            EndpointsAndWeights endpointsAndWeights = this.endpointsAndWeights;
            if (endpointsAndWeights == null) {
                return null;
            }
            int currentSequence = this.sequence.getAndIncrement();
            return endpointsAndWeights.selectEndpoint(currentSequence);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("endpointsAndWeights", this.endpointsAndWeights).toString();
        }

        private static final class EndpointsAndWeights {
            private final List<Endpoint> endpoints;
            private final boolean weighted;
            private final long totalWeight;
            private final List<EndpointsGroupByWeight> accumulatedGroups;

            EndpointsAndWeights(Iterable<Endpoint> endpoints) {
                this.endpoints = Streams.stream(endpoints).filter(e -> e.weight() > 0).sorted(Comparator.comparing(Endpoint::weight).thenComparing(Endpoint::host).thenComparingInt(Endpoint::port)).collect(ImmutableList.toImmutableList());
                long numEndpoints = this.endpoints.size();
                int minWeight = Integer.MAX_VALUE;
                int maxWeight = Integer.MIN_VALUE;
                int numberDistinctWeight = 0;
                int oldWeight = -1;
                for (Endpoint endpoint : this.endpoints) {
                    int weight = endpoint.weight();
                    minWeight = Math.min(minWeight, weight);
                    maxWeight = Math.max(maxWeight, weight);
                    numberDistinctWeight += weight == oldWeight ? 0 : 1;
                    oldWeight = weight;
                }
                long totalWeight = 0L;
                ImmutableList.Builder accumulatedGroupsBuilder = ImmutableList.builderWithExpectedSize(numberDistinctWeight);
                EndpointsGroupByWeight currentGroup = null;
                long rest = numEndpoints;
                for (Endpoint endpoint : this.endpoints) {
                    if (currentGroup == null || currentGroup.weight != endpoint.weight()) {
                        currentGroup = new EndpointsGroupByWeight(numEndpoints - rest, endpoint.weight(), totalWeight += currentGroup == null ? (long)endpoint.weight() * rest : (long)(endpoint.weight() - currentGroup.weight) * rest);
                        accumulatedGroupsBuilder.add(currentGroup);
                    }
                    --rest;
                }
                this.accumulatedGroups = accumulatedGroupsBuilder.build();
                this.totalWeight = totalWeight;
                this.weighted = minWeight != maxWeight;
            }

            @Nullable
            Endpoint selectEndpoint(int currentSequence) {
                if (this.endpoints.isEmpty()) {
                    return null;
                }
                if (this.weighted) {
                    int mid;
                    long numberEndpoints = this.endpoints.size();
                    long mod = Math.abs((long)currentSequence % this.totalWeight);
                    if (mod < this.accumulatedGroups.get((int)0).accumulatedWeight) {
                        return this.endpoints.get((int)(mod % numberEndpoints));
                    }
                    int left = 0;
                    int right = this.accumulatedGroups.size() - 1;
                    while (left < right && (mid = left + (right - left >> 1)) != left) {
                        if (this.accumulatedGroups.get((int)mid).accumulatedWeight <= mod) {
                            left = mid;
                            continue;
                        }
                        right = mid;
                    }
                    long indexInPart = mod - this.accumulatedGroups.get((int)left).accumulatedWeight;
                    long startIndex = this.accumulatedGroups.get((int)(left + 1)).startIndex;
                    return this.endpoints.get((int)(startIndex + indexInPart % (numberEndpoints - startIndex)));
                }
                return this.endpoints.get(Math.abs(currentSequence % this.endpoints.size()));
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("endpoints", this.endpoints).add("weighted", this.weighted).add("totalWeight", this.totalWeight).add("accumulatedGroups", this.accumulatedGroups).toString();
            }
        }

        private static final class EndpointsGroupByWeight {
            final long startIndex;
            final int weight;
            final long accumulatedWeight;

            EndpointsGroupByWeight(long startIndex, int weight, long accumulatedWeight) {
                this.startIndex = startIndex;
                this.weight = weight;
                this.accumulatedWeight = accumulatedWeight;
            }
        }
    }
}

