/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint.dns;

import java.util.List;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import karate.com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import karate.com.linecorp.armeria.client.endpoint.dns.DnsEndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.dns.DnsQueryListener;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.SystemInfo;
import karate.com.linecorp.armeria.internal.client.dns.ByteArrayDnsRecord;
import karate.com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import karate.com.linecorp.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import karate.com.linecorp.armeria.internal.client.dns.DnsUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.handler.codec.dns.DnsRecord;
import karate.io.netty.handler.codec.dns.DnsRecordType;
import karate.io.netty.resolver.ResolvedAddressTypes;
import karate.io.netty.util.NetUtil;

public final class DnsAddressEndpointGroup
extends DnsEndpointGroup {
    private final String hostname;
    private final int port;

    public static DnsAddressEndpointGroup of(String hostname) {
        return DnsAddressEndpointGroup.builder(hostname).build();
    }

    public static DnsAddressEndpointGroup of(String hostname, int port) {
        return DnsAddressEndpointGroup.builder(hostname).port(port).build();
    }

    public static DnsAddressEndpointGroupBuilder builder(String hostname) {
        return new DnsAddressEndpointGroupBuilder(hostname);
    }

    DnsAddressEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, long selectionTimeoutMillis, DefaultDnsResolver resolver, EventLoop eventLoop, Backoff backoff, int minTtl, int maxTtl, @Nullable ResolvedAddressTypes resolvedAddressTypes, String hostname, int port, List<DnsQueryListener> dnsQueryListeners) {
        super(selectionStrategy, allowEmptyEndpoints, selectionTimeoutMillis, resolver, eventLoop, DnsAddressEndpointGroup.newQuestions(hostname, resolvedAddressTypes), backoff, minTtl, maxTtl, dnsQueryListeners);
        this.hostname = hostname;
        this.port = port;
        this.start();
    }

    private static List<DnsQuestionWithoutTrailingDot> newQuestions(String hostname, @Nullable ResolvedAddressTypes resolvedAddressTypes) {
        if (resolvedAddressTypes == null) {
            resolvedAddressTypes = SystemInfo.hasIpV6() ? ResolvedAddressTypes.IPV4_PREFERRED : ResolvedAddressTypes.IPV4_ONLY;
        }
        DnsQuestionWithoutTrailingDot ipV4 = DnsQuestionWithoutTrailingDot.of(hostname, DnsRecordType.A);
        DnsQuestionWithoutTrailingDot ipV6 = DnsQuestionWithoutTrailingDot.of(hostname, DnsRecordType.AAAA);
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return ImmutableList.of(ipV4);
            }
            case IPV6_ONLY: {
                return ImmutableList.of(ipV6);
            }
            case IPV4_PREFERRED: {
                return ImmutableList.of(ipV4, ipV6);
            }
            case IPV6_PREFERRED: {
                return ImmutableList.of(ipV6, ipV4);
            }
        }
        throw new Error();
    }

    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        boolean hasLoopbackARecords = records.stream().filter(ByteArrayDnsRecord.class::isInstance).map(ByteArrayDnsRecord.class::cast).anyMatch(r -> {
            byte[] content = r.content();
            return r.type() == DnsRecordType.A && content.length > 0 && content[0] == 127;
        });
        for (DnsRecord r2 : records) {
            String ipAddr;
            byte[] addrBytes;
            if (!(r2 instanceof ByteArrayDnsRecord) || (addrBytes = DnsUtil.extractAddressBytes(r2, this.logger(), this.logPrefix())) == null) continue;
            int contentLen = addrBytes.length;
            if (contentLen == 16) {
                if (addrBytes[0] == 0 && addrBytes[1] == 0 && addrBytes[2] == 0 && addrBytes[3] == 0 && addrBytes[4] == 0 && addrBytes[5] == 0 && addrBytes[6] == 0 && addrBytes[7] == 0 && addrBytes[8] == 0 && addrBytes[9] == 0) {
                    if (addrBytes[10] == 0 && addrBytes[11] == 0) {
                        if (addrBytes[12] == 0 && addrBytes[13] == 0 && addrBytes[14] == 0 && addrBytes[15] == 1) {
                            if (hasLoopbackARecords) continue;
                            ipAddr = "::1";
                        } else {
                            ipAddr = NetUtil.bytesToIpAddress(addrBytes, 12, 4);
                        }
                    } else {
                        ipAddr = addrBytes[10] == -1 && addrBytes[11] == -1 ? NetUtil.bytesToIpAddress(addrBytes, 12, 4) : NetUtil.bytesToIpAddress(addrBytes);
                    }
                } else {
                    ipAddr = NetUtil.bytesToIpAddress(addrBytes);
                }
            } else {
                ipAddr = NetUtil.bytesToIpAddress(addrBytes);
            }
            Endpoint endpoint = Endpoint.unsafeCreate(this.hostname, this.port);
            builder.add(endpoint.withIpAddr(ipAddr));
        }
        ImmutableSet endpoints = builder.build();
        this.logDnsResolutionResult(endpoints, ttl);
        return endpoints;
    }
}

