/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint.dns;

import java.util.List;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import karate.com.linecorp.armeria.client.endpoint.dns.DnsEndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.dns.DnsQueryListener;
import karate.com.linecorp.armeria.client.endpoint.dns.DnsServiceEndpointGroupBuilder;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.internal.client.dns.ByteArrayDnsRecord;
import karate.com.linecorp.armeria.internal.client.dns.DefaultDnsResolver;
import karate.com.linecorp.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import karate.io.netty.handler.codec.dns.DnsRecord;
import karate.io.netty.handler.codec.dns.DnsRecordType;

public final class DnsServiceEndpointGroup
extends DnsEndpointGroup {
    public static DnsServiceEndpointGroup of(String hostname) {
        return DnsServiceEndpointGroup.builder(hostname).build();
    }

    public static DnsServiceEndpointGroupBuilder builder(String hostname) {
        return new DnsServiceEndpointGroupBuilder(hostname);
    }

    DnsServiceEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, long selectionTimeoutMillis, DefaultDnsResolver resolver, EventLoop eventLoop, Backoff backoff, int minTtl, int maxTtl, String hostname, List<DnsQueryListener> dnsQueryListeners) {
        super(selectionStrategy, allowEmptyEndpoints, selectionTimeoutMillis, resolver, eventLoop, ImmutableList.of(DnsQuestionWithoutTrailingDot.of(hostname, DnsRecordType.SRV)), backoff, minTtl, maxTtl, dnsQueryListeners);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (DnsRecord r : records) {
            Endpoint endpoint;
            if (!(r instanceof ByteArrayDnsRecord) || r.type() != DnsRecordType.SRV) continue;
            byte[] content = ((ByteArrayDnsRecord)r).content();
            if (content.length <= 6) {
                this.warnInvalidRecord(DnsRecordType.SRV, content);
                continue;
            }
            ByteBuf contentBuf = Unpooled.wrappedBuffer(content);
            contentBuf.markReaderIndex();
            contentBuf.skipBytes(2);
            int weight = contentBuf.readUnsignedShort();
            int port = contentBuf.readUnsignedShort();
            try {
                String target = DnsServiceEndpointGroup.stripTrailingDot(DefaultDnsRecordDecoder.decodeName(contentBuf));
                endpoint = port > 0 ? Endpoint.of(target, port) : Endpoint.of(target);
            }
            catch (Exception e) {
                this.warnInvalidRecord(DnsRecordType.SRV, content);
                continue;
            }
            finally {
                contentBuf.release();
                continue;
            }
            builder.add(endpoint.withWeight(weight));
        }
        ImmutableSet endpoints = builder.build();
        this.logDnsResolutionResult(endpoints, ttl);
        return endpoints;
    }

    private static String stripTrailingDot(String name) {
        if (name.endsWith(".")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

