/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint.healthcheck;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import karate.com.linecorp.armeria.client.ClientFactory;
import karate.com.linecorp.armeria.client.ClientOptions;
import karate.com.linecorp.armeria.client.ClientOptionsBuilder;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.AbstractDynamicEndpointGroupBuilder;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckStrategy;
import karate.com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.auth.AuthToken;
import karate.com.linecorp.armeria.common.util.AsyncCloseable;
import karate.com.linecorp.armeria.internal.client.endpoint.EndpointAttributeKeys;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.math.LongMath;

public abstract class AbstractHealthCheckedEndpointGroupBuilder<SELF extends AbstractHealthCheckedEndpointGroupBuilder<SELF>>
extends AbstractDynamicEndpointGroupBuilder<SELF> {
    static final Backoff DEFAULT_HEALTH_CHECK_RETRY_BACKOFF = Backoff.fixed(3000L).withJitter(0.2);
    static final Predicate<Endpoint> DEFAULT_ENDPOINT_PREDICATE = endpoint -> Boolean.TRUE.equals(endpoint.attr(EndpointAttributeKeys.HEALTHY_ATTR));
    private final EndpointGroup delegate;
    private SessionProtocol protocol = SessionProtocol.HTTP;
    private Backoff retryBackoff = DEFAULT_HEALTH_CHECK_RETRY_BACKOFF;
    private ClientOptionsBuilder clientOptionsBuilder = ClientOptions.builder();
    private int port;
    @Nullable
    private Double maxEndpointRatio;
    @Nullable
    private Integer maxEndpointCount;
    private long initialSelectionTimeoutMillis = Flags.defaultResponseTimeoutMillis();
    private long selectionTimeoutMillis = Flags.defaultConnectTimeoutMillis();
    private Predicate<Endpoint> healthCheckedEndpointPredicate = DEFAULT_ENDPOINT_PREDICATE;

    protected AbstractHealthCheckedEndpointGroupBuilder(EndpointGroup delegate) {
        super(Flags.defaultResponseTimeoutMillis());
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public SELF clientFactory(ClientFactory clientFactory) {
        this.clientOptionsBuilder.factory(Objects.requireNonNull(clientFactory, "clientFactory"));
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF protocol(SessionProtocol protocol) {
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF port(int port) {
        Preconditions.checkArgument(port > 0 && port <= 65535, "port: %s (expected: 1-65535)", port);
        this.port = port;
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF retryInterval(Duration retryInterval) {
        Objects.requireNonNull(retryInterval, "retryInterval");
        Preconditions.checkArgument(!retryInterval.isNegative() && !retryInterval.isZero(), "retryInterval: %s (expected: > 0)", (Object)retryInterval);
        return this.retryIntervalMillis(retryInterval.toMillis());
    }

    public SELF retryIntervalMillis(long retryIntervalMillis) {
        Preconditions.checkArgument(retryIntervalMillis > 0L, "retryIntervalMillis: %s (expected: > 0)", retryIntervalMillis);
        return this.retryBackoff(Backoff.fixed(retryIntervalMillis).withJitter(0.2));
    }

    public SELF retryBackoff(Backoff retryBackoff) {
        this.retryBackoff = Objects.requireNonNull(retryBackoff, "retryBackoff");
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF clientOptions(ClientOptions clientOptions) {
        this.clientOptionsBuilder.options(Objects.requireNonNull(clientOptions, "clientOptions"));
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF withClientOptions(Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator) {
        ClientOptionsBuilder newBuilder = Objects.requireNonNull(configurator, "configurator").apply(this.clientOptionsBuilder);
        Preconditions.checkState(newBuilder != null, "configurator returned null.");
        this.clientOptionsBuilder = newBuilder;
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF maxEndpointRatio(double maxEndpointRatio) {
        if (this.maxEndpointCount != null) {
            throw new IllegalArgumentException("Maximum endpoint count is already set.");
        }
        Preconditions.checkArgument(maxEndpointRatio > 0.0 && maxEndpointRatio <= 1.0, "maxEndpointRatio: %s (expected: 0.0 < maxEndpointRatio <= 1.0)", (Object)maxEndpointRatio);
        this.maxEndpointRatio = maxEndpointRatio;
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF maxEndpointCount(int maxEndpointCount) {
        if (this.maxEndpointRatio != null) {
            throw new IllegalArgumentException("Maximum endpoint ratio is already set.");
        }
        Preconditions.checkArgument(maxEndpointCount > 0, "maxEndpointCount: %s (expected: > 0)", maxEndpointCount);
        this.maxEndpointCount = maxEndpointCount;
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public SELF auth(AuthToken token) {
        Objects.requireNonNull(token, "token");
        this.clientOptionsBuilder.auth(token);
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    @Override
    @UnstableApi
    public SELF selectionTimeout(Duration selectionTimeout) {
        return this.selectionTimeout(selectionTimeout, selectionTimeout);
    }

    @UnstableApi
    public SELF selectionTimeout(Duration initialSelectionTimeout, Duration selectionTimeout) {
        Objects.requireNonNull(initialSelectionTimeout, "initialSelectionTimeout");
        Objects.requireNonNull(selectionTimeout, "selectionTimeout");
        return this.selectionTimeoutMillis(initialSelectionTimeout.toMillis(), selectionTimeout.toMillis());
    }

    @Override
    @UnstableApi
    public SELF selectionTimeoutMillis(long selectionTimeoutMillis) {
        return this.selectionTimeoutMillis(selectionTimeoutMillis, selectionTimeoutMillis);
    }

    @UnstableApi
    public SELF selectionTimeoutMillis(long initialSelectionTimeoutMillis, long selectionTimeoutMillis) {
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        Preconditions.checkArgument(initialSelectionTimeoutMillis >= 0L, "initialSelectionTimeoutMillis: %s (expected: >= 0)", initialSelectionTimeoutMillis);
        if (initialSelectionTimeoutMillis == 0L) {
            initialSelectionTimeoutMillis = Long.MAX_VALUE;
        }
        if (selectionTimeoutMillis == 0L) {
            selectionTimeoutMillis = Long.MAX_VALUE;
        }
        this.initialSelectionTimeoutMillis = initialSelectionTimeoutMillis;
        this.selectionTimeoutMillis = selectionTimeoutMillis;
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    @UnstableApi
    public SELF healthCheckedEndpointPredicate(Predicate<Endpoint> healthCheckedEndpointPredicate) {
        this.healthCheckedEndpointPredicate = Objects.requireNonNull(healthCheckedEndpointPredicate, "healthCheckedEndpointPredicate");
        return (SELF)((AbstractHealthCheckedEndpointGroupBuilder)this.self());
    }

    public final HealthCheckedEndpointGroup build() {
        HealthCheckStrategy healthCheckStrategy = this.maxEndpointCount != null ? HealthCheckStrategy.ofCount(this.maxEndpointCount) : (this.maxEndpointRatio == null || this.maxEndpointRatio == 1.0 ? HealthCheckStrategy.all() : HealthCheckStrategy.ofRatio(this.maxEndpointRatio));
        long initialSelectionTimeoutMillis = LongMath.saturatedAdd(this.initialSelectionTimeoutMillis, this.delegate.selectionTimeoutMillis());
        long selectionTimeoutMillis = LongMath.saturatedAdd(this.selectionTimeoutMillis, this.delegate.selectionTimeoutMillis());
        return new HealthCheckedEndpointGroup(this.delegate, this.shouldAllowEmptyEndpoints(), initialSelectionTimeoutMillis, selectionTimeoutMillis, this.protocol, this.port, this.retryBackoff, this.clientOptionsBuilder.build(), this.newCheckerFactory(), healthCheckStrategy, this.healthCheckedEndpointPredicate);
    }

    protected abstract Function<? super HealthCheckerContext, ? extends AsyncCloseable> newCheckerFactory();
}

