/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint.healthcheck;

import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.endpoint.healthcheck.AbstractHealthCheckedEndpointGroupBuilder;
import karate.com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import karate.com.linecorp.armeria.common.util.AsyncCloseable;
import karate.com.linecorp.armeria.internal.client.endpoint.healthcheck.DefaultHttpHealthChecker;

public final class HealthCheckedEndpointGroupBuilder
extends AbstractHealthCheckedEndpointGroupBuilder<HealthCheckedEndpointGroupBuilder> {
    private final String path;
    private boolean useGet;

    HealthCheckedEndpointGroupBuilder(EndpointGroup delegate, String path) {
        super(delegate);
        this.path = Objects.requireNonNull(path, "path");
    }

    public HealthCheckedEndpointGroupBuilder useGet(boolean useGet) {
        this.useGet = useGet;
        return this;
    }

    @Override
    protected Function<? super HealthCheckerContext, ? extends AsyncCloseable> newCheckerFactory() {
        return new HttpHealthCheckerFactory(this.path, this.useGet);
    }

    private static class HttpHealthCheckerFactory
    implements Function<HealthCheckerContext, AsyncCloseable> {
        private final String path;
        private final boolean useGet;

        HttpHealthCheckerFactory(String path, boolean useGet) {
            this.path = path;
            this.useGet = useGet;
        }

        @Override
        public AsyncCloseable apply(HealthCheckerContext ctx) {
            DefaultHttpHealthChecker checker = new DefaultHttpHealthChecker(ctx, ctx.endpoint(), this.path, this.useGet, ctx.protocol(), null);
            checker.start();
            return checker;
        }
    }
}

