/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.endpoint.healthcheck;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckStrategy;
import karate.com.linecorp.armeria.client.endpoint.healthcheck.PartialHealthCheckStrategyBuilder;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;

final class PartialHealthCheckStrategy
implements HealthCheckStrategy {
    private final EndpointLimitingFunction endpointLimitingFunction;

    static PartialHealthCheckStrategyBuilder builder() {
        return new PartialHealthCheckStrategyBuilder();
    }

    PartialHealthCheckStrategy(EndpointLimitingFunction endpointLimitingFunction) {
        this.endpointLimitingFunction = Objects.requireNonNull(endpointLimitingFunction, "endpointLimitingFunction");
    }

    @Override
    public List<Endpoint> select(List<Endpoint> candidates) {
        int numEndpoints;
        int numCandidates = (candidates = (List)candidates.stream().distinct().collect(ImmutableList.toImmutableList())).size();
        if (numCandidates == (numEndpoints = this.endpointLimitingFunction.calculate(numCandidates))) {
            return candidates;
        }
        return PartialHealthCheckStrategy.sampleEndpoints(candidates, numEndpoints);
    }

    private static List<Endpoint> sampleEndpoints(List<Endpoint> candidates, int numSamples) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(numSamples);
        int numCandidates = candidates.size();
        int i = 0;
        while (numSamples > 0) {
            int rand = ((Random)random).nextInt(numCandidates - i);
            if (rand < numSamples) {
                builder.add(candidates.get(i));
                --numSamples;
            }
            ++i;
        }
        return builder.build();
    }

    static final class EndpointLimitingFunction {
        private final int count;
        private final double ratio;
        private final boolean ratioMode;

        private EndpointLimitingFunction(int count, double ratio, boolean ratioMode) {
            this.count = count;
            this.ratio = ratio;
            this.ratioMode = ratioMode;
        }

        static EndpointLimitingFunction ofCount(int count) {
            Preconditions.checkArgument(count > 0, "count: %s (expected: 0 < count <= MAX_INT)", count);
            return new EndpointLimitingFunction(count, 0.0, false);
        }

        static EndpointLimitingFunction ofRatio(double ratio) {
            Preconditions.checkArgument(0.0 < ratio && ratio <= 1.0, "ratio: %s (expected: 0 < ratio <= 1)", (Object)ratio);
            return new EndpointLimitingFunction(0, ratio, true);
        }

        int calculate(int numCandidates) {
            if (this.ratioMode) {
                return Math.max(1, (int)((double)numCandidates * this.ratio));
            }
            return Math.min(this.count, numCandidates);
        }
    }
}

